/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AddressModel;
import com.liferay.portal.kernel.model.AddressSoap;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.AddressCacheModel;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.osgi.annotation.versioning.ProviderType;

@JSON(strict=true)
@ProviderType
public class AddressModelImpl
extends BaseModelImpl<Address>
implements AddressModel {
    public static final String TABLE_NAME = "Address";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"mvccVersion", -5}, {"uuid_", 12}, {"addressId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"classNameId", -5}, {"classPK", -5}, {"street1", 12}, {"street2", 12}, {"street3", 12}, {"city", 12}, {"zip", 12}, {"regionId", -5}, {"countryId", -5}, {"typeId", -5}, {"mailing", 16}, {"primary_", 16}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table Address (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,addressId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,street1 VARCHAR(75) null,street2 VARCHAR(75) null,street3 VARCHAR(75) null,city VARCHAR(75) null,zip VARCHAR(75) null,regionId LONG,countryId LONG,typeId LONG,mailing BOOLEAN,primary_ BOOLEAN)";
    public static final String TABLE_SQL_DROP = "drop table Address";
    public static final String ORDER_BY_JPQL = " ORDER BY address.createDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY Address.createDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED;
    public static final boolean FINDER_CACHE_ENABLED;
    public static final boolean COLUMN_BITMASK_ENABLED;
    public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;
    public static final long CLASSPK_COLUMN_BITMASK = 2L;
    public static final long COMPANYID_COLUMN_BITMASK = 4L;
    public static final long MAILING_COLUMN_BITMASK = 8L;
    public static final long PRIMARY_COLUMN_BITMASK = 16L;
    public static final long USERID_COLUMN_BITMASK = 32L;
    public static final long UUID_COLUMN_BITMASK = 64L;
    public static final long CREATEDATE_COLUMN_BITMASK = 128L;
    public static final long LOCK_EXPIRATION_TIME;
    private static final Map<String, Function<Address, Object>> _attributeGetterFunctions;
    private static final Map<String, BiConsumer<Address, Object>> _attributeSetterBiConsumers;
    private static final Function<InvocationHandler, Address> _escapedModelProxyProviderFunction;
    private long _mvccVersion;
    private String _uuid;
    private String _originalUuid;
    private long _addressId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _userId;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private boolean _setModifiedDate;
    private long _classNameId;
    private long _originalClassNameId;
    private boolean _setOriginalClassNameId;
    private long _classPK;
    private long _originalClassPK;
    private boolean _setOriginalClassPK;
    private String _street1;
    private String _street2;
    private String _street3;
    private String _city;
    private String _zip;
    private long _regionId;
    private long _countryId;
    private long _typeId;
    private boolean _mailing;
    private boolean _originalMailing;
    private boolean _setOriginalMailing;
    private boolean _primary;
    private boolean _originalPrimary;
    private boolean _setOriginalPrimary;
    private long _columnBitmask;
    private Address _escapedModel;

    public static Address toModel(AddressSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        AddressImpl model = new AddressImpl();
        model.setMvccVersion(soapModel.getMvccVersion());
        model.setUuid(soapModel.getUuid());
        model.setAddressId(soapModel.getAddressId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setClassNameId(soapModel.getClassNameId());
        model.setClassPK(soapModel.getClassPK());
        model.setStreet1(soapModel.getStreet1());
        model.setStreet2(soapModel.getStreet2());
        model.setStreet3(soapModel.getStreet3());
        model.setCity(soapModel.getCity());
        model.setZip(soapModel.getZip());
        model.setRegionId(soapModel.getRegionId());
        model.setCountryId(soapModel.getCountryId());
        model.setTypeId(soapModel.getTypeId());
        model.setMailing(soapModel.isMailing());
        model.setPrimary(soapModel.isPrimary());
        return model;
    }

    public static List<Address> toModels(AddressSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<Address> models = new ArrayList<Address>(soapModels.length);
        for (AddressSoap soapModel : soapModels) {
            models.add(AddressModelImpl.toModel(soapModel));
        }
        return models;
    }

    @Override
    public long getPrimaryKey() {
        return this._addressId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        this.setAddressId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._addressId);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    @Override
    public Class<?> getModelClass() {
        return Address.class;
    }

    @Override
    public String getModelClassName() {
        return Address.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Function<Address, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        for (Map.Entry<String, Function<Address, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<Address, Object> attributeGetterFunction = entry.getValue();
            attributes.put(attributeName, attributeGetterFunction.apply((Address)((Object)this)));
        }
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Map<String, BiConsumer<Address, Object>> attributeSetterBiConsumers = this.getAttributeSetterBiConsumers();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            BiConsumer<Address, Object> attributeSetterBiConsumer = attributeSetterBiConsumers.get(attributeName);
            if (attributeSetterBiConsumer == null) continue;
            attributeSetterBiConsumer.accept((Address)((Object)this), entry.getValue());
        }
    }

    public Map<String, Function<Address, Object>> getAttributeGetterFunctions() {
        return _attributeGetterFunctions;
    }

    public Map<String, BiConsumer<Address, Object>> getAttributeSetterBiConsumers() {
        return _attributeSetterBiConsumers;
    }

    private static Function<InvocationHandler, Address> _getProxyProviderFunction() {
        Class<?> proxyClass = ProxyUtil.getProxyClass(Address.class.getClassLoader(), Address.class, ModelWrapper.class);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (Address)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException roe) {
                    throw new InternalError(roe);
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new InternalError(nsme);
        }
    }

    @Override
    @JSON
    public long getMvccVersion() {
        return this._mvccVersion;
    }

    @Override
    public void setMvccVersion(long mvccVersion) {
        this._mvccVersion = mvccVersion;
    }

    @Override
    @JSON
    public String getUuid() {
        if (this._uuid == null) {
            return "";
        }
        return this._uuid;
    }

    @Override
    public void setUuid(String uuid) {
        this._columnBitmask |= 0x40L;
        if (this._originalUuid == null) {
            this._originalUuid = this._uuid;
        }
        this._uuid = uuid;
    }

    public String getOriginalUuid() {
        return GetterUtil.getString(this._originalUuid);
    }

    @Override
    @JSON
    public long getAddressId() {
        return this._addressId;
    }

    @Override
    public void setAddressId(long addressId) {
        this._addressId = addressId;
    }

    @Override
    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._columnBitmask |= 4L;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @Override
    @JSON
    public long getUserId() {
        return this._userId;
    }

    @Override
    public void setUserId(long userId) {
        this._columnBitmask |= 0x20L;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    @Override
    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById(this.getUserId());
            return user.getUuid();
        }
        catch (PortalException pe) {
            return "";
        }
    }

    @Override
    public void setUserUuid(String userUuid) {
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    @Override
    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    @Override
    public void setUserName(String userName) {
        this._userName = userName;
    }

    @Override
    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this._columnBitmask = -1L;
        this._createDate = createDate;
    }

    @Override
    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean hasSetModifiedDate() {
        return this._setModifiedDate;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this._setModifiedDate = true;
        this._modifiedDate = modifiedDate;
    }

    @Override
    public String getClassName() {
        if (this.getClassNameId() <= 0L) {
            return "";
        }
        return PortalUtil.getClassName(this.getClassNameId());
    }

    @Override
    public void setClassName(String className) {
        long classNameId = 0L;
        if (Validator.isNotNull(className)) {
            classNameId = PortalUtil.getClassNameId(className);
        }
        this.setClassNameId(classNameId);
    }

    @Override
    @JSON
    public long getClassNameId() {
        return this._classNameId;
    }

    @Override
    public void setClassNameId(long classNameId) {
        this._columnBitmask |= 1L;
        if (!this._setOriginalClassNameId) {
            this._setOriginalClassNameId = true;
            this._originalClassNameId = this._classNameId;
        }
        this._classNameId = classNameId;
    }

    public long getOriginalClassNameId() {
        return this._originalClassNameId;
    }

    @Override
    @JSON
    public long getClassPK() {
        return this._classPK;
    }

    @Override
    public void setClassPK(long classPK) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalClassPK) {
            this._setOriginalClassPK = true;
            this._originalClassPK = this._classPK;
        }
        this._classPK = classPK;
    }

    public long getOriginalClassPK() {
        return this._originalClassPK;
    }

    @Override
    @JSON
    public String getStreet1() {
        if (this._street1 == null) {
            return "";
        }
        return this._street1;
    }

    @Override
    public void setStreet1(String street1) {
        this._street1 = street1;
    }

    @Override
    @JSON
    public String getStreet2() {
        if (this._street2 == null) {
            return "";
        }
        return this._street2;
    }

    @Override
    public void setStreet2(String street2) {
        this._street2 = street2;
    }

    @Override
    @JSON
    public String getStreet3() {
        if (this._street3 == null) {
            return "";
        }
        return this._street3;
    }

    @Override
    public void setStreet3(String street3) {
        this._street3 = street3;
    }

    @Override
    @JSON
    public String getCity() {
        if (this._city == null) {
            return "";
        }
        return this._city;
    }

    @Override
    public void setCity(String city) {
        this._city = city;
    }

    @Override
    @JSON
    public String getZip() {
        if (this._zip == null) {
            return "";
        }
        return this._zip;
    }

    @Override
    public void setZip(String zip) {
        this._zip = zip;
    }

    @Override
    @JSON
    public long getRegionId() {
        return this._regionId;
    }

    @Override
    public void setRegionId(long regionId) {
        this._regionId = regionId;
    }

    @Override
    @JSON
    public long getCountryId() {
        return this._countryId;
    }

    @Override
    public void setCountryId(long countryId) {
        this._countryId = countryId;
    }

    @Override
    @JSON
    public long getTypeId() {
        return this._typeId;
    }

    @Override
    public void setTypeId(long typeId) {
        this._typeId = typeId;
    }

    @Override
    @JSON
    public boolean getMailing() {
        return this._mailing;
    }

    @Override
    @JSON
    public boolean isMailing() {
        return this._mailing;
    }

    @Override
    public void setMailing(boolean mailing) {
        this._columnBitmask |= 8L;
        if (!this._setOriginalMailing) {
            this._setOriginalMailing = true;
            this._originalMailing = this._mailing;
        }
        this._mailing = mailing;
    }

    public boolean getOriginalMailing() {
        return this._originalMailing;
    }

    @Override
    @JSON
    public boolean getPrimary() {
        return this._primary;
    }

    @Override
    @JSON
    public boolean isPrimary() {
        return this._primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this._columnBitmask |= 0x10L;
        if (!this._setOriginalPrimary) {
            this._setOriginalPrimary = true;
            this._originalPrimary = this._primary;
        }
        this._primary = primary;
    }

    public boolean getOriginalPrimary() {
        return this._originalPrimary;
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(PortalUtil.getClassNameId(Address.class.getName()), this.getClassNameId());
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(this.getCompanyId(), Address.class.getName(), this.getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Address toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = _escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler(this));
        }
        return this._escapedModel;
    }

    @Override
    public Object clone() {
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.setMvccVersion(this.getMvccVersion());
        addressImpl.setUuid(this.getUuid());
        addressImpl.setAddressId(this.getAddressId());
        addressImpl.setCompanyId(this.getCompanyId());
        addressImpl.setUserId(this.getUserId());
        addressImpl.setUserName(this.getUserName());
        addressImpl.setCreateDate(this.getCreateDate());
        addressImpl.setModifiedDate(this.getModifiedDate());
        addressImpl.setClassNameId(this.getClassNameId());
        addressImpl.setClassPK(this.getClassPK());
        addressImpl.setStreet1(this.getStreet1());
        addressImpl.setStreet2(this.getStreet2());
        addressImpl.setStreet3(this.getStreet3());
        addressImpl.setCity(this.getCity());
        addressImpl.setZip(this.getZip());
        addressImpl.setRegionId(this.getRegionId());
        addressImpl.setCountryId(this.getCountryId());
        addressImpl.setTypeId(this.getTypeId());
        addressImpl.setMailing(this.isMailing());
        addressImpl.setPrimary(this.isPrimary());
        addressImpl.resetOriginalValues();
        return addressImpl;
    }

    @Override
    public int compareTo(Address address) {
        int value = 0;
        value = DateUtil.compareTo(this.getCreateDate(), address.getCreateDate());
        if (value != 0) {
            return value;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address address = (Address)obj;
        long primaryKey = address.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    @Override
    public boolean isEntityCacheEnabled() {
        return ENTITY_CACHE_ENABLED;
    }

    @Override
    public boolean isFinderCacheEnabled() {
        return FINDER_CACHE_ENABLED;
    }

    @Override
    public void resetOriginalValues() {
        AddressModelImpl addressModelImpl = this;
        addressModelImpl._originalUuid = addressModelImpl._uuid;
        addressModelImpl._originalCompanyId = addressModelImpl._companyId;
        addressModelImpl._setOriginalCompanyId = false;
        addressModelImpl._originalUserId = addressModelImpl._userId;
        addressModelImpl._setOriginalUserId = false;
        addressModelImpl._setModifiedDate = false;
        addressModelImpl._originalClassNameId = addressModelImpl._classNameId;
        addressModelImpl._setOriginalClassNameId = false;
        addressModelImpl._originalClassPK = addressModelImpl._classPK;
        addressModelImpl._setOriginalClassPK = false;
        addressModelImpl._originalMailing = addressModelImpl._mailing;
        addressModelImpl._setOriginalMailing = false;
        addressModelImpl._originalPrimary = addressModelImpl._primary;
        addressModelImpl._setOriginalPrimary = false;
        addressModelImpl._columnBitmask = 0L;
    }

    @Override
    public CacheModel<Address> toCacheModel() {
        String zip;
        String city;
        String street3;
        String street2;
        Date createDate;
        AddressCacheModel addressCacheModel = new AddressCacheModel();
        addressCacheModel.mvccVersion = this.getMvccVersion();
        addressCacheModel.uuid = this.getUuid();
        String uuid = addressCacheModel.uuid;
        if (uuid != null && uuid.length() == 0) {
            addressCacheModel.uuid = null;
        }
        addressCacheModel.addressId = this.getAddressId();
        addressCacheModel.companyId = this.getCompanyId();
        addressCacheModel.userId = this.getUserId();
        addressCacheModel.userName = this.getUserName();
        String userName = addressCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            addressCacheModel.userName = null;
        }
        addressCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        addressCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        addressCacheModel.classNameId = this.getClassNameId();
        addressCacheModel.classPK = this.getClassPK();
        addressCacheModel.street1 = this.getStreet1();
        String street1 = addressCacheModel.street1;
        if (street1 != null && street1.length() == 0) {
            addressCacheModel.street1 = null;
        }
        if ((street2 = (addressCacheModel.street2 = this.getStreet2())) != null && street2.length() == 0) {
            addressCacheModel.street2 = null;
        }
        if ((street3 = (addressCacheModel.street3 = this.getStreet3())) != null && street3.length() == 0) {
            addressCacheModel.street3 = null;
        }
        if ((city = (addressCacheModel.city = this.getCity())) != null && city.length() == 0) {
            addressCacheModel.city = null;
        }
        if ((zip = (addressCacheModel.zip = this.getZip())) != null && zip.length() == 0) {
            addressCacheModel.zip = null;
        }
        addressCacheModel.regionId = this.getRegionId();
        addressCacheModel.countryId = this.getCountryId();
        addressCacheModel.typeId = this.getTypeId();
        addressCacheModel.mailing = this.isMailing();
        addressCacheModel.primary = this.isPrimary();
        return addressCacheModel;
    }

    public String toString() {
        Map<String, Function<Address, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(4 * attributeGetterFunctions.size() + 2);
        sb.append("{");
        for (Map.Entry<String, Function<Address, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<Address, Object> attributeGetterFunction = entry.getValue();
            sb.append(attributeName);
            sb.append("=");
            sb.append(attributeGetterFunction.apply((Address)((Object)this)));
            sb.append(", ");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toXmlString() {
        Map<String, Function<Address, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);
        sb.append("<model><model-name>");
        sb.append(this.getModelClassName());
        sb.append("</model-name>");
        for (Map.Entry<String, Function<Address, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<Address, Object> attributeGetterFunction = entry.getValue();
            sb.append("<column><column-name>");
            sb.append(attributeName);
            sb.append("</column-name><column-value><![CDATA[");
            sb.append(attributeGetterFunction.apply((Address)((Object)this)));
            sb.append("]]></column-value></column>");
        }
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("mvccVersion", -5);
        TABLE_COLUMNS_MAP.put("uuid_", 12);
        TABLE_COLUMNS_MAP.put("addressId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("modifiedDate", 93);
        TABLE_COLUMNS_MAP.put("classNameId", -5);
        TABLE_COLUMNS_MAP.put("classPK", -5);
        TABLE_COLUMNS_MAP.put("street1", 12);
        TABLE_COLUMNS_MAP.put("street2", 12);
        TABLE_COLUMNS_MAP.put("street3", 12);
        TABLE_COLUMNS_MAP.put("city", 12);
        TABLE_COLUMNS_MAP.put("zip", 12);
        TABLE_COLUMNS_MAP.put("regionId", -5);
        TABLE_COLUMNS_MAP.put("countryId", -5);
        TABLE_COLUMNS_MAP.put("typeId", -5);
        TABLE_COLUMNS_MAP.put("mailing", 16);
        TABLE_COLUMNS_MAP.put("primary_", 16);
        ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.kernel.model.Address"), true);
        FINDER_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.kernel.model.Address"), true);
        COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.kernel.model.Address"), true);
        LOCK_EXPIRATION_TIME = GetterUtil.getLong(PropsUtil.get("lock.expiration.time.com.liferay.portal.kernel.model.Address"));
        LinkedHashMap<String, Function<Address, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<Address, Object>>();
        LinkedHashMap<String, BiConsumer<Address, Object>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<Address, Object>>();
        attributeGetterFunctions.put("mvccVersion", AddressModel::getMvccVersion);
        attributeSetterBiConsumers.put("mvccVersion", AddressModel::setMvccVersion);
        attributeGetterFunctions.put("uuid", AddressModel::getUuid);
        attributeSetterBiConsumers.put("uuid", AddressModel::setUuid);
        attributeGetterFunctions.put("addressId", AddressModel::getAddressId);
        attributeSetterBiConsumers.put("addressId", AddressModel::setAddressId);
        attributeGetterFunctions.put("companyId", AddressModel::getCompanyId);
        attributeSetterBiConsumers.put("companyId", AddressModel::setCompanyId);
        attributeGetterFunctions.put("userId", AddressModel::getUserId);
        attributeSetterBiConsumers.put("userId", AddressModel::setUserId);
        attributeGetterFunctions.put("userName", AddressModel::getUserName);
        attributeSetterBiConsumers.put("userName", AddressModel::setUserName);
        attributeGetterFunctions.put("createDate", AddressModel::getCreateDate);
        attributeSetterBiConsumers.put("createDate", AddressModel::setCreateDate);
        attributeGetterFunctions.put("modifiedDate", AddressModel::getModifiedDate);
        attributeSetterBiConsumers.put("modifiedDate", AddressModel::setModifiedDate);
        attributeGetterFunctions.put("classNameId", AddressModel::getClassNameId);
        attributeSetterBiConsumers.put("classNameId", AddressModel::setClassNameId);
        attributeGetterFunctions.put("classPK", AddressModel::getClassPK);
        attributeSetterBiConsumers.put("classPK", AddressModel::setClassPK);
        attributeGetterFunctions.put("street1", AddressModel::getStreet1);
        attributeSetterBiConsumers.put("street1", AddressModel::setStreet1);
        attributeGetterFunctions.put("street2", AddressModel::getStreet2);
        attributeSetterBiConsumers.put("street2", AddressModel::setStreet2);
        attributeGetterFunctions.put("street3", AddressModel::getStreet3);
        attributeSetterBiConsumers.put("street3", AddressModel::setStreet3);
        attributeGetterFunctions.put("city", AddressModel::getCity);
        attributeSetterBiConsumers.put("city", AddressModel::setCity);
        attributeGetterFunctions.put("zip", AddressModel::getZip);
        attributeSetterBiConsumers.put("zip", AddressModel::setZip);
        attributeGetterFunctions.put("regionId", AddressModel::getRegionId);
        attributeSetterBiConsumers.put("regionId", AddressModel::setRegionId);
        attributeGetterFunctions.put("countryId", AddressModel::getCountryId);
        attributeSetterBiConsumers.put("countryId", AddressModel::setCountryId);
        attributeGetterFunctions.put("typeId", AddressModel::getTypeId);
        attributeSetterBiConsumers.put("typeId", AddressModel::setTypeId);
        attributeGetterFunctions.put("mailing", AddressModel::getMailing);
        attributeSetterBiConsumers.put("mailing", AddressModel::setMailing);
        attributeGetterFunctions.put("primary", AddressModel::getPrimary);
        attributeSetterBiConsumers.put("primary", AddressModel::setPrimary);
        _attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
        _attributeSetterBiConsumers = Collections.unmodifiableMap(attributeSetterBiConsumers);
        _escapedModelProxyProviderFunction = AddressModelImpl._getProxyProviderFunction();
    }
}

