/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import java.util.Date;

public class PortletPreferencesModelListener
extends BaseModelListener<PortletPreferences> {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesModelListener.class);

    @Override
    public void onAfterRemove(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
    }

    @Override
    public void onAfterUpdate(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
        this.updateLayout(portletPreferences);
    }

    protected void clearCache(PortletPreferences portletPreferences) {
        if (portletPreferences == null) {
            return;
        }
        try {
            long companyId = 0L;
            Layout layout = LayoutUtil.fetchByPrimaryKey(portletPreferences.getPlid());
            if (layout != null && !layout.isPrivateLayout()) {
                companyId = layout.getCompanyId();
            } else {
                LayoutRevision layoutRevision = LayoutRevisionUtil.fetchByPrimaryKey(portletPreferences.getPlid());
                if (layoutRevision != null && !layoutRevision.isPrivateLayout()) {
                    companyId = layoutRevision.getCompanyId();
                }
            }
            if (companyId > 0L) {
                CacheUtil.clearCache(companyId);
            }
        }
        catch (Exception e) {
            CacheUtil.clearCache();
        }
    }

    protected void updateLayout(PortletPreferences portletPreferences) {
        try {
            if (portletPreferences.getOwnerType() == 2 && portletPreferences.getOwnerId() > 0L) {
                Group group = GroupLocalServiceUtil.fetchGroup(portletPreferences.getOwnerId());
                if (group == null) {
                    return;
                }
                String className = group.getClassName();
                if (!className.equals(LayoutSetPrototype.class.getName())) {
                    return;
                }
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototype(group.getClassPK());
                if (layoutSetPrototype == null) {
                    return;
                }
                layoutSetPrototype.setModifiedDate(new Date());
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype(layoutSetPrototype);
            } else if (portletPreferences.getOwnerType() == 3 && portletPreferences.getPlid() > 0L) {
                Layout layout = LayoutLocalServiceUtil.fetchLayout(portletPreferences.getPlid());
                if (layout == null) {
                    return;
                }
                layout.setModifiedDate(new Date());
                LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
            }
        }
        catch (Exception e) {
            _log.error("Unable to update the layout's modified date", e);
        }
    }
}

