/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;

public class LayoutModelListener
extends BaseModelListener<Layout> {
    @Override
    public void onAfterCreate(Layout layout) {
        this.clearCache(layout);
    }

    @Override
    public void onAfterRemove(Layout layout) {
        this.clearCache(layout);
    }

    @Override
    public void onAfterUpdate(Layout layout) {
        this.clearCache(layout);
    }

    @Override
    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        try {
            if (layout == null || !LayoutStagingUtil.isBranchingLayout(layout)) {
                return;
            }
            LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions(layout.getPlid());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (PortalException pe) {
            throw new ModelListenerException(pe);
        }
        catch (SystemException se) {
            throw new ModelListenerException(se);
        }
    }

    protected void clearCache(Layout layout) {
        if (layout == null) {
            return;
        }
        if (!layout.isPrivateLayout()) {
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }
}

