/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.CSSCompressor;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import org.apache.commons.lang.time.StopWatch;

public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static final ServiceTracker<JavaScriptMinifier, JavaScriptMinifier> _javaScriptMinifierServiceTracker;

    public static String minifyCss(String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyCss(content);
        }
        return content;
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyJavaScript(resourceName, content);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyCss(String content) {
        String string;
        block6: {
            int length;
            StopWatch stopWatch;
            block7: {
                byte[] bytes;
                stopWatch = new StopWatch();
                stopWatch.start();
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                try {
                    CSSCompressor cssCompressor = new CSSCompressor(new UnsyncStringReader(content));
                    cssCompressor.compress(unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
                    string = unsyncStringWriter.toString();
                    if (!_log.isDebugEnabled()) break block6;
                    length = 0;
                    if (content == null) break block7;
                    bytes = content.getBytes();
                }
                catch (Exception e) {
                    String string2;
                    block8: {
                        int length2;
                        block9: {
                            byte[] bytes2;
                            try {
                                _log.error("Unable to minify CSS:\n" + content, e);
                                unsyncStringWriter.append(content);
                                string2 = unsyncStringWriter.toString();
                                if (!_log.isDebugEnabled()) break block8;
                                length2 = 0;
                                if (content == null) break block9;
                                bytes2 = content.getBytes();
                            }
                            catch (Throwable throwable) {
                                if (_log.isDebugEnabled()) {
                                    int length3 = 0;
                                    if (content != null) {
                                        byte[] bytes3 = content.getBytes();
                                        length3 = bytes3.length;
                                    }
                                    _log.debug(StringBundler.concat("Minification for ", length3, " bytes of CSS took ", stopWatch.getTime(), " ms"));
                                }
                                throw throwable;
                            }
                            length2 = bytes2.length;
                        }
                        _log.debug(StringBundler.concat("Minification for ", length2, " bytes of CSS took ", stopWatch.getTime(), " ms"));
                    }
                    return string2;
                }
                length = bytes.length;
            }
            _log.debug(StringBundler.concat("Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyJavaScript(String resourceName, String content) {
        String string;
        block5: {
            int length;
            StopWatch stopWatch;
            block6: {
                byte[] bytes;
                JavaScriptMinifier javaScriptMinifier = _javaScriptMinifierServiceTracker.getService();
                if (javaScriptMinifier == null) {
                    return content;
                }
                stopWatch = new StopWatch();
                stopWatch.start();
                try {
                    string = javaScriptMinifier.compress(resourceName, content);
                    if (!_log.isDebugEnabled()) break block5;
                    length = 0;
                    if (content == null) break block6;
                    bytes = content.getBytes();
                }
                catch (Throwable throwable) {
                    if (_log.isDebugEnabled()) {
                        int length2 = 0;
                        if (content != null) {
                            byte[] bytes2 = content.getBytes();
                            length2 = bytes2.length;
                        }
                        _log.debug(StringBundler.concat("Minification for ", length2, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"));
                    }
                    throw throwable;
                }
                length = bytes.length;
            }
            _log.debug(StringBundler.concat("Minification for ", length, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"));
        }
        return string;
    }

    private MinifierUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _javaScriptMinifierServiceTracker = registry.trackServices(JavaScriptMinifier.class);
        _javaScriptMinifierServiceTracker.open();
    }
}

