/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.xml;

import com.liferay.portal.kernel.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayRenderResponse;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import javax.portlet.RenderResponse;

public class ActionURLLogic
extends RuntimeLogic {
    public static final String CLOSE_1_TAG = "</runtime-action-url>";
    public static final String CLOSE_2_TAG = "/>";
    public static final String OPEN_TAG = "<runtime-action-url";
    private static final String _LIFECYCLE = "ACTION_PHASE";
    private final LiferayRenderResponse _liferayRenderResponse;

    public ActionURLLogic(RenderResponse renderResponse) {
        this._liferayRenderResponse = (LiferayRenderResponse)renderResponse;
    }

    @Override
    public String getClose1Tag() {
        return CLOSE_1_TAG;
    }

    public String getLifecycle() {
        return _LIFECYCLE;
    }

    @Override
    public String getOpenTag() {
        return OPEN_TAG;
    }

    @Override
    public String processXML(String xml) throws Exception {
        Document doc = SAXReaderUtil.read(xml);
        Element root = doc.getRootElement();
        LiferayPortletURL liferayPortletURL = this._liferayRenderResponse.createLiferayPortletURL(this.getLifecycle());
        String portletId = root.attributeValue("portlet-name");
        if (portletId != null) {
            portletId = PortalUtil.getJsSafePortletId(portletId);
            liferayPortletURL.setPortletId(portletId);
        }
        int i = 1;
        while (true) {
            String paramName = root.attributeValue("param-name-" + i);
            String paramValue = root.attributeValue("param-value-" + i);
            if (paramName == null || paramValue == null) break;
            liferayPortletURL.setParameter(paramName, paramValue);
            ++i;
        }
        return liferayPortletURL.toString();
    }
}

