/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.layoutconfiguration.util.RuntimePage;
import com.liferay.portal.kernel.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.CustomizationSettingsProcessor;
import com.liferay.portal.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portal.layoutconfiguration.util.xml.ActionURLLogic;
import com.liferay.portal.layoutconfiguration.util.xml.PortletLogic;
import com.liferay.portal.layoutconfiguration.util.xml.RenderURLLogic;
import com.liferay.portal.servlet.ThreadLocalFacadeServletRequestWrapperUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.internal.PortletBagUtil;
import com.liferay.portlet.internal.PortletTypeUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.DummyVelocityTaglib;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.Portlet;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public class RuntimePageImpl
implements RuntimePage {
    private static final Log _log = LogFactoryUtil.getLog(RuntimePageImpl.class);
    private static volatile PortalExecutorManager _portalExecutorManager = ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, RuntimePageImpl.class, "_portalExecutorManager", true);
    private int _waitTime = Integer.MAX_VALUE;

    public static ThreadPoolHandler getThreadPoolHandler() {
        return new ThreadPoolHandlerAdapter(){

            @Override
            public void afterExecute(Runnable runnable, Throwable throwable) {
                CentralizedThreadLocal.clearShortLivedThreadLocals();
            }
        };
    }

    @Override
    public StringBundler getProcessedTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource) throws Exception {
        return this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, "vm", true);
    }

    @Override
    public void processCustomizationSettings(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource) throws Exception {
        this.processCustomizationSettings(httpServletRequest, httpServletResponse, templateResource, "vm");
    }

    @Override
    public void processCustomizationSettings(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource, String langType) throws Exception {
        this.doDispatch(httpServletRequest, httpServletResponse, null, templateResource, langType, false);
    }

    @Override
    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource) throws Exception {
        StringBundler sb = this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, "vm", true);
        sb.writeTo(httpServletResponse.getWriter());
    }

    @Override
    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType) throws Exception {
        StringBundler sb = this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, langType, true);
        sb.writeTo(httpServletResponse.getWriter());
    }

    @Override
    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource) throws Exception {
        this.processTemplate(httpServletRequest, httpServletResponse, null, templateResource);
    }

    @Override
    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource, String langType) throws Exception {
        this.processTemplate(httpServletRequest, httpServletResponse, null, templateResource, langType);
    }

    @Override
    public String processXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String content) throws Exception {
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletResponse != null && !(portletResponse instanceof RenderResponse)) {
            throw new IllegalArgumentException("processXML can only be invoked in the render phase");
        }
        PortletLogic portletLogic = new PortletLogic(httpServletRequest, httpServletResponse);
        content = this.processXML(httpServletRequest, content, portletLogic);
        if (portletResponse == null) {
            return content;
        }
        RenderResponse renderResponse = (RenderResponse)portletResponse;
        ActionURLLogic actionURLLogic = new ActionURLLogic(renderResponse);
        RenderURLLogic renderURLLogic = new RenderURLLogic(renderResponse);
        content = this.processXML(httpServletRequest, content, actionURLLogic);
        content = this.processXML(httpServletRequest, content, renderURLLogic);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processXML(HttpServletRequest httpServletRequest, String content, RuntimeLogic runtimeLogic) throws Exception {
        if (Validator.isNull(content)) {
            return "";
        }
        int index = content.indexOf(runtimeLogic.getOpenTag());
        if (index == -1) {
            return content;
        }
        com.liferay.portal.kernel.model.Portlet renderPortlet = (com.liferay.portal.kernel.model.Portlet)httpServletRequest.getAttribute("RENDER_PORTLET");
        Boolean renderPortletResource = (Boolean)httpServletRequest.getAttribute("RENDER_PORTLET_RESOURCE");
        String outerPortletId = (String)httpServletRequest.getAttribute("OUTER_PORTLET_ID");
        if (outerPortletId == null) {
            httpServletRequest.setAttribute("OUTER_PORTLET_ID", (Object)renderPortlet.getPortletId());
        }
        try {
            httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            StringBundler sb = new StringBundler();
            int x = 0;
            int y = index;
            while (y != -1) {
                sb.append(content.substring(x, y));
                String close1Tag = runtimeLogic.getClose1Tag();
                String close2Tag = runtimeLogic.getClose2Tag();
                int close1 = content.indexOf(close1Tag, y);
                int close2 = content.indexOf(close2Tag, y);
                x = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + close1Tag.length() : close2 + close2Tag.length();
                String runtimePortletTag = content.substring(y, x);
                if (renderPortlet != null && runtimePortletTag.contains(renderPortlet.getPortletId())) {
                    String string = "";
                    return string;
                }
                sb.append(runtimeLogic.processXML(runtimePortletTag));
                y = content.indexOf(runtimeLogic.getOpenTag(), x);
            }
            if (y == -1) {
                sb.append(content.substring(x));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (outerPortletId == null) {
                httpServletRequest.removeAttribute("OUTER_PORTLET_ID");
            }
            httpServletRequest.setAttribute("RENDER_PORTLET", (Object)renderPortlet);
            if (renderPortletResource == null) {
                httpServletRequest.removeAttribute("RENDER_PORTLET_RESOURCE");
            } else {
                httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)renderPortletResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBundler doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType, boolean processTemplate) throws Exception {
        String pluginServletContextName;
        ServletContext pluginServletContext;
        ClassLoader pluginClassLoader = null;
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(templateResource.getTemplateId());
        if (layoutTemplate != null && (pluginServletContext = ServletContextPool.get(pluginServletContextName = GetterUtil.getString(layoutTemplate.getServletContextName()))) != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(pluginClassLoader);
            }
            if (processTemplate) {
                StringBundler stringBundler = this.doProcessTemplate(httpServletRequest, httpServletResponse, portletId, templateResource, langType, false);
                return stringBundler;
            }
            this.doProcessCustomizationSettings(httpServletRequest, httpServletResponse, templateResource, langType, false);
            StringBundler stringBundler = null;
            return stringBundler;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected void doProcessCustomizationSettings(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource, String langType, boolean restricted) throws Exception {
        CustomizationSettingsProcessor processor = new CustomizationSettingsProcessor(httpServletRequest, httpServletResponse);
        Template template = TemplateManagerUtil.getTemplate(langType, templateResource, restricted);
        template.put("processor", processor);
        template.prepare(httpServletRequest);
        DummyVelocityTaglib velocityTaglib = new DummyVelocityTaglib();
        template.put("taglibLiferay", velocityTaglib);
        template.put("theme", velocityTaglib);
        try {
            template.processTemplate(httpServletResponse.getWriter());
        }
        catch (Exception e) {
            _log.error(e, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBundler doProcessTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType, boolean restricted) throws Exception {
        TemplateProcessor processor = new TemplateProcessor(httpServletRequest, httpServletResponse, portletId);
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager(langType);
        Template template = templateManager.getTemplate(templateResource, restricted);
        template.put("processor", processor);
        template.prepare(httpServletRequest);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        templateManager.addTaglibTheme(template, "taglibLiferay", httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, unsyncStringWriter));
        try {
            template.processTemplate(unsyncStringWriter);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw e;
        }
        Map<Integer, List<PortletRenderer>> portletRenderersMap = processor.getPortletRenderers();
        HashMap<String, Map<String, Object>> portletHeaderRequestMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processing portlets with render weight " + entry.getKey());
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug("Start serial header phase");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                Portlet portlet;
                com.liferay.portal.kernel.model.Portlet portletModel = portletRenderer.getPortlet();
                if (!portletModel.isReady() || !PortletTypeUtil.isHeaderPortlet(portlet = PortletBagUtil.getPortletInstance(httpServletRequest.getServletContext(), portletModel, portletModel.getRootPortletId()))) continue;
                Map<String, Object> headerRequestMap = portletRenderer.renderHeaders(httpServletRequest, httpServletResponse, portletModel.getHeaderRequestAttributePrefixes());
                String rendererPortletId = portletModel.getPortletId();
                portletHeaderRequestMap.put(rendererPortletId, headerRequestMap);
                if (!_log.isDebugEnabled()) continue;
                StringBundler sb = new StringBundler(5);
                sb.append("Serially rendered headers for portlet ");
                sb.append(rendererPortletId);
                sb.append(" in ");
                sb.append(stopWatch.getTime());
                sb.append(" ms");
                _log.debug(sb.toString());
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug("Finished serial header phase in " + stopWatch.getTime() + " ms");
        }
        boolean portletParallelRender = GetterUtil.getBoolean(httpServletRequest.getAttribute("PORTLET_PARALLEL_RENDER"));
        ReentrantLock lock = null;
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processing portlets with render weight " + entry.getKey());
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (portletParallelRender && portletRenderers.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Start parallel rendering");
                }
                if (lock == null) {
                    lock = new ReentrantLock();
                }
                httpServletRequest.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", (Object)lock);
                ObjectValuePair<HttpServletRequest, Closeable> objectValuePair = ThreadLocalFacadeServletRequestWrapperUtil.inject(httpServletRequest);
                try {
                    this.parallelyRenderPortlets(objectValuePair.getKey(), httpServletResponse, processor, contentsMap, portletHeaderRequestMap, portletRenderers);
                }
                finally {
                    Closeable closeable = objectValuePair.getValue();
                    closeable.close();
                }
                httpServletRequest.removeAttribute("PARALLEL_RENDERING_MERGE_LOCK");
                if (!_log.isDebugEnabled()) continue;
                _log.debug("Finished parallel rendering in " + stopWatch.getTime() + " ms");
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Start serial rendering");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                com.liferay.portal.kernel.model.Portlet portlet = portletRenderer.getPortlet();
                String rendererPortletId = portlet.getPortletId();
                contentsMap.put(rendererPortletId, portletRenderer.render(httpServletRequest, httpServletResponse, (Map)portletHeaderRequestMap.get(rendererPortletId)));
                if (!_log.isDebugEnabled()) continue;
                _log.debug(StringBundler.concat("Serially rendered portlet ", rendererPortletId, " in ", String.valueOf(stopWatch.getTime()), " ms"));
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug("Finished serial rendering in " + stopWatch.getTime() + " ms");
        }
        if (portletParallelRender && this._waitTime == Integer.MAX_VALUE) {
            this._waitTime = PropsValues.LAYOUT_PARALLEL_RENDER_TIMEOUT;
        }
        return StringUtil.replaceWithStringBundler(unsyncStringWriter.toString(), "[$TEMPLATE_PORTLET_", "$]", contentsMap);
    }

    protected LayoutTemplate getLayoutTemplate(String velocityTemplateId) {
        String separator = "_CUSTOM_";
        boolean standard = false;
        if (velocityTemplateId.contains("_STANDARD_")) {
            separator = "_STANDARD_";
            standard = true;
        }
        String layoutTemplateId = null;
        String themeId = null;
        int pos = velocityTemplateId.indexOf(separator);
        if (pos != -1) {
            layoutTemplateId = velocityTemplateId.substring(pos + separator.length());
            themeId = velocityTemplateId.substring(0, pos);
        }
        if ((pos = layoutTemplateId.indexOf("_INSTANCE_")) != -1) {
            layoutTemplateId = layoutTemplateId.substring(pos + "_INSTANCE_".length() + 1);
            pos = layoutTemplateId.indexOf("_");
            layoutTemplateId = layoutTemplateId.substring(pos + 1);
        }
        return LayoutTemplateLocalServiceUtil.getLayoutTemplate(layoutTemplateId, standard, themeId);
    }

    protected void parallelyRenderPortlets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateProcessor processor, Map<String, StringBundler> contentsMap, Map<String, Map<String, Object>> portletHeaderRequestMap, List<PortletRenderer> portletRenderers) throws Exception {
        NoticeableExecutorService executorService = _portalExecutorManager.getPortalExecutor(RuntimePageImpl.class.getName());
        HashMap<Future<StringBundler>, PortletRenderer> futures = new HashMap<Future<StringBundler>, PortletRenderer>(portletRenderers.size());
        for (PortletRenderer portletRenderer : portletRenderers) {
            com.liferay.portal.kernel.model.Portlet portlet = portletRenderer.getPortlet();
            String rendererPortletId = portlet.getPortletId();
            if (_log.isDebugEnabled()) {
                _log.debug("Submit portlet " + rendererPortletId + " for parallel rendering");
            }
            Callable<StringBundler> renderCallable = portletRenderer.getCallable(httpServletRequest, httpServletResponse, portletHeaderRequestMap.get(rendererPortletId));
            Future<StringBundler> future = null;
            try {
                future = executorService.submit(renderCallable);
            }
            catch (RejectedExecutionException ree) {
                future = new FutureTask<StringBundler>(renderCallable);
                future.cancel(true);
            }
            futures.put(future, portletRenderer);
        }
        long waitTime = this._waitTime;
        for (Map.Entry entry : futures.entrySet()) {
            Future future = (Future)entry.getKey();
            PortletRenderer portletRenderer = (PortletRenderer)entry.getValue();
            com.liferay.portal.kernel.model.Portlet portlet = portletRenderer.getPortlet();
            if (future.isCancelled()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Reject portlet " + portlet.getPortletId() + " for parallel rendering");
                }
            } else if (waitTime > 0L || future.isDone()) {
                try {
                    long startTime = System.currentTimeMillis();
                    StringBundler sb = (StringBundler)future.get(waitTime, TimeUnit.MILLISECONDS);
                    long duration = System.currentTimeMillis() - startTime;
                    waitTime -= duration;
                    contentsMap.put(portlet.getPortletId(), sb);
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug(StringBundler.concat("Parallely rendered portlet ", portlet.getPortletId(), " in ", String.valueOf(duration), " ms"));
                    continue;
                }
                catch (ExecutionException ee) {
                    throw ee;
                }
                catch (InterruptedException ie) {
                    waitTime = -1L;
                }
                catch (TimeoutException te) {
                    waitTime = -1L;
                }
                catch (CancellationException ce) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("Asynchronized cancellation detected that should only be caused by a concurrent shutdown of the thread pool", ce);
                    }
                    return;
                }
                future.cancel(true);
            }
            StringBundler sb = null;
            if (processor.isPortletAjaxRender() && portlet.isAjaxable()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Fall back to ajax rendering of portlet " + portlet.getPortletId());
                }
                sb = portletRenderer.renderAjax(httpServletRequest, httpServletResponse);
            } else {
                if (_log.isDebugEnabled()) {
                    if (processor.isPortletAjaxRender()) {
                        _log.debug("Fall back to an error message for portlet " + portlet.getPortletId() + " since it is not ajaxable");
                    } else {
                        _log.debug("Fall back to an error message for portlet " + portlet.getPortletId() + " since ajax rendering is disabled");
                    }
                }
                sb = portletRenderer.renderError(httpServletRequest, httpServletResponse);
            }
            contentsMap.put(portlet.getPortletId(), sb);
        }
        for (PortletRenderer portletRender : portletRenderers) {
            portletRender.finishParallelRender();
        }
    }
}

