/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.ThreadLocalBinder;
import com.liferay.portal.layoutconfiguration.util.ParallelRenderThreadLocalBinderUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRenderer {
    private static final String _RENDER_PATH = "/html/portal/load_render_portlet.jsp";
    private final Integer _columnCount;
    private final String _columnId;
    private final Integer _columnPos;
    private final Portlet _portlet;
    private RestrictPortletServletRequest _restrictPortletServletRequest;

    public PortletRenderer(Portlet portlet, String columnId, Integer columnCount, Integer columnPos) {
        this._portlet = portlet;
        this._columnId = columnId;
        this._columnCount = columnCount;
        this._columnPos = columnPos;
    }

    public void finishParallelRender() {
        if (this._restrictPortletServletRequest != null) {
            this._restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public Callable<StringBundler> getCallable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> headerRequestAttributes) {
        return new PortletRendererCallable(httpServletRequest, httpServletResponse, headerRequestAttributes);
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public StringBundler render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> headerRequestAttributes) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters(httpServletRequest, null, this._columnId, this._columnPos, this._columnCount);
        this._copyHeaderRequestAttributes(headerRequestAttributes, httpServletRequest);
        return this._render(httpServletRequest, httpServletResponse);
    }

    public StringBundler renderAjax(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters(httpServletRequest, _RENDER_PATH, this._columnId, this._columnPos, this._columnCount);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)httpServletRequest;
        return this._render(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBundler renderError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters(httpServletRequest, null, this._columnId, this._columnPos, this._columnCount);
        httpServletRequest.setAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR", (Object)Boolean.TRUE);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)httpServletRequest;
        try {
            StringBundler stringBundler = this._render(httpServletRequest, httpServletResponse);
            return stringBundler;
        }
        finally {
            httpServletRequest.removeAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR");
        }
    }

    public Map<String, Object> renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<String> attributePrefixes) throws PortletContainerException {
        httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters(httpServletRequest, null, this._columnId, this._columnPos, this._columnCount);
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        PortletContainerUtil.renderHeaders(httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, this._portlet);
        HashMap<String, Object> headerRequestAttributes = new HashMap<String, Object>();
        Enumeration attributeNames = httpServletRequest.getAttributeNames();
        block0: while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (attributeName.contains("javax.portlet.faces.renderResponseOutput")) {
                headerRequestAttributes.put(attributeName, httpServletRequest.getAttribute(attributeName));
                continue;
            }
            if (attributePrefixes == null) continue;
            for (String attributePrefix : attributePrefixes) {
                if (!attributeName.contains(attributePrefix)) continue;
                headerRequestAttributes.put(attributeName, httpServletRequest.getAttribute(attributeName));
                continue block0;
            }
        }
        return headerRequestAttributes;
    }

    private void _copyHeaderRequestAttributes(Map<String, Object> headerRequestAttributes, HttpServletRequest httpServletRequest) {
        if (headerRequestAttributes != null) {
            for (Map.Entry<String, Object> entry : headerRequestAttributes.entrySet()) {
                httpServletRequest.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private StringBundler _render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortletContainerException {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        Object lock = httpServletRequest.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
        httpServletRequest.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", null);
        Object portletParallelRender = httpServletRequest.getAttribute("PORTLET_PARALLEL_RENDER");
        httpServletRequest.setAttribute("PORTLET_PARALLEL_RENDER", (Object)Boolean.FALSE);
        try {
            PortletContainerUtil.render(httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, this._portlet);
            StringBundler stringBundler = bufferCacheServletResponse.getStringBundler();
            return stringBundler;
        }
        catch (IOException ioe) {
            throw new PortletContainerException(ioe);
        }
        finally {
            httpServletRequest.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", lock);
            httpServletRequest.setAttribute("PORTLET_PARALLEL_RENDER", portletParallelRender);
        }
    }

    private class PortletRendererCallable
    extends CopyThreadLocalCallable<StringBundler> {
        private final Map<String, Object> _headerRequestAttributes;
        private final HttpServletRequest _httpServletRequest;
        private final HttpServletResponse _httpServletResponse;

        public PortletRendererCallable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> headerRequestAttributes) {
            super(ParallelRenderThreadLocalBinderUtil.getThreadLocalBinder(), false, true);
            this._httpServletRequest = httpServletRequest;
            this._httpServletResponse = httpServletResponse;
            this._headerRequestAttributes = headerRequestAttributes;
        }

        @Override
        public StringBundler doCall() throws Exception {
            HttpServletRequest httpServletRequest = PortletContainerUtil.setupOptionalRenderParameters(this._httpServletRequest, null, PortletRenderer.this._columnId, PortletRenderer.this._columnPos, PortletRenderer.this._columnCount);
            PortletRenderer.this._copyHeaderRequestAttributes(this._headerRequestAttributes, httpServletRequest);
            PortletRenderer.this._restrictPortletServletRequest = (RestrictPortletServletRequest)httpServletRequest;
            try {
                this._split(this._httpServletRequest, PortletRenderer.this._restrictPortletServletRequest);
                return PortletRenderer.this._render(httpServletRequest, this._httpServletResponse);
            }
            catch (Exception e) {
                Thread currentThread = Thread.currentThread();
                if (!currentThread.isInterrupted()) {
                    throw e;
                }
                return null;
            }
        }

        private void _split(HttpServletRequest httpServletRequest, RestrictPortletServletRequest restrictPortletServletRequest) {
            Enumeration attributeNames = httpServletRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attribute = httpServletRequest.getAttribute(attributeName);
                if (!(attribute instanceof Mergeable) || !RestrictPortletServletRequest.isSharedRequestAttribute(attributeName)) continue;
                Mergeable mergeable = (Mergeable)attribute;
                restrictPortletServletRequest.setAttribute(attributeName, mergeable.split());
            }
        }
    }

    private abstract class CopyThreadLocalCallable<T>
    implements Callable<T> {
        private final boolean _clearOnExit;
        private final Map<CentralizedThreadLocal<?>, Object> _longLivedThreadLocals;
        private final Map<CentralizedThreadLocal<?>, Object> _shortLivedlThreadLocals;
        private final ThreadLocalBinder _threadLocalBinder;

        public CopyThreadLocalCallable(boolean readOnly, boolean clearOnExit) {
            this(null, readOnly, clearOnExit);
        }

        public CopyThreadLocalCallable(ThreadLocalBinder threadLocalBinder, boolean readOnly, boolean clearOnExit) {
            this._threadLocalBinder = threadLocalBinder;
            if (this._threadLocalBinder != null) {
                this._threadLocalBinder.record();
            }
            if (readOnly) {
                this._longLivedThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getLongLivedThreadLocals());
                this._shortLivedlThreadLocals = Collections.unmodifiableMap(CentralizedThreadLocal.getShortLivedThreadLocals());
            } else {
                this._longLivedThreadLocals = CentralizedThreadLocal.getLongLivedThreadLocals();
                this._shortLivedlThreadLocals = CentralizedThreadLocal.getShortLivedThreadLocals();
            }
            this._clearOnExit = clearOnExit;
        }

        @Override
        public final T call() throws Exception {
            CentralizedThreadLocal.setThreadLocals(this._longLivedThreadLocals, this._shortLivedlThreadLocals);
            if (this._threadLocalBinder != null) {
                this._threadLocalBinder.bind();
            }
            try {
                T t = this.doCall();
                return t;
            }
            finally {
                if (this._clearOnExit) {
                    if (this._threadLocalBinder != null) {
                        this._threadLocalBinder.cleanUp();
                    }
                    CentralizedThreadLocal.clearLongLivedThreadLocals();
                    CentralizedThreadLocal.clearShortLivedThreadLocals();
                }
            }
        }

        public abstract T doCall() throws Exception;
    }
}

