/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.memory.EqualityWeakReference;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class AggregateClassLoader
extends ClassLoader {
    private static final Method _FIND_CLASS_METHOD;
    private static final Method _GET_RESOURCE_METHOD;
    private static final Method _GET_RESOURCES_METHOD;
    private static final Method _LOAD_CLASS_METHOD;
    private final List<EqualityWeakReference<ClassLoader>> _classLoaderReferences = new ArrayList<EqualityWeakReference<ClassLoader>>();

    public static ClassLoader getAggregateClassLoader(ClassLoader parentClassLoader, ClassLoader ... classLoaders) {
        if (ArrayUtil.isEmpty(classLoaders)) {
            return parentClassLoader;
        }
        AggregateClassLoader aggregateClassLoader = null;
        if (parentClassLoader instanceof AggregateClassLoader) {
            aggregateClassLoader = (AggregateClassLoader)parentClassLoader;
            List<ClassLoader> existingClassLoaders = aggregateClassLoader.getClassLoaders();
            boolean requiresNew = false;
            for (ClassLoader classLoader : classLoaders) {
                if (classLoader.equals(parentClassLoader) || existingClassLoaders.contains(classLoader)) continue;
                requiresNew = true;
                break;
            }
            if (!requiresNew) {
                return aggregateClassLoader;
            }
            aggregateClassLoader = new AggregateClassLoader(parentClassLoader.getParent());
            aggregateClassLoader.addClassLoader(parentClassLoader);
        } else {
            aggregateClassLoader = new AggregateClassLoader(parentClassLoader);
        }
        for (ClassLoader classLoader : classLoaders) {
            aggregateClassLoader.addClassLoader(classLoader);
        }
        return aggregateClassLoader;
    }

    public static ClassLoader getAggregateClassLoader(ClassLoader[] classLoaders) {
        if (ArrayUtil.isEmpty(classLoaders)) {
            return null;
        }
        return AggregateClassLoader.getAggregateClassLoader(classLoaders[0], classLoaders);
    }

    public AggregateClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (classLoader.equals(this.getParent())) {
            return;
        }
        List<ClassLoader> classLoaders = this.getClassLoaders();
        if (classLoaders.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof AggregateClassLoader) {
            AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)classLoader;
            this.addClassLoader(aggregateClassLoader.getParent());
            for (ClassLoader curClassLoader : aggregateClassLoader.getClassLoaders()) {
                this.addClassLoader(curClassLoader);
            }
            return;
        }
        this._classLoaderReferences.add(new EqualityWeakReference<ClassLoader>(classLoader));
    }

    public void addClassLoader(ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public void addClassLoader(Collection<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AggregateClassLoader)) {
            return false;
        }
        AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)obj;
        return this._classLoaderReferences.equals(aggregateClassLoader._classLoaderReferences) && Objects.equals(this.getParent(), aggregateClassLoader.getParent());
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this._classLoaderReferences.size());
        Iterator<EqualityWeakReference<ClassLoader>> itr = this._classLoaderReferences.iterator();
        while (itr.hasNext()) {
            WeakReference weakReference = itr.next();
            ClassLoader classLoader = (ClassLoader)weakReference.get();
            if (classLoader == null) {
                itr.remove();
                continue;
            }
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL url = AggregateClassLoader._getResource(classLoader, name);
            if (url == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader classLoader : this.getClassLoaders()) {
            urls.addAll(Collections.list(AggregateClassLoader._getResources(classLoader, name)));
        }
        urls.addAll(Collections.list(AggregateClassLoader._getResources(this.getParent(), name)));
        return Collections.enumeration(urls);
    }

    public int hashCode() {
        int hash = HashUtil.hash(0, this._classLoaderReferences);
        return HashUtil.hash(hash, this.getParent());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return AggregateClassLoader._findClass(classLoader, name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException("Unable to find class " + name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                loadedClass = AggregateClassLoader._loadClass(classLoader, name, resolve);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (loadedClass == null) {
            loadedClass = AggregateClassLoader._loadClass(this.getParent(), name, resolve);
        } else if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private static Class<?> _findClass(ClassLoader classLoader, String name) throws ClassNotFoundException {
        try {
            return (Class)_FIND_CLASS_METHOD.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException ite) {
            throw new ClassNotFoundException("Unable to find class " + name, ite.getTargetException());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to find class " + name, e);
        }
    }

    private static URL _getResource(ClassLoader classLoader, String name) {
        try {
            return (URL)_GET_RESOURCE_METHOD.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException ite) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Enumeration<URL> _getResources(ClassLoader classLoader, String name) throws IOException {
        try {
            return (Enumeration)_GET_RESOURCES_METHOD.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            throw new IOException(t);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Class<?> _loadClass(ClassLoader classLoader, String name, boolean resolve) throws ClassNotFoundException {
        try {
            return (Class)_LOAD_CLASS_METHOD.invoke((Object)classLoader, name, resolve);
        }
        catch (InvocationTargetException ite) {
            throw new ClassNotFoundException("Unable to load class " + name, ite.getTargetException());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to load class " + name, e);
        }
    }

    static {
        try {
            _FIND_CLASS_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "findClass", String.class);
            _GET_RESOURCE_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getResource", String.class);
            _GET_RESOURCES_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getResources", String.class);
            _LOAD_CLASS_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "loadClass", String.class, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError(e);
        }
    }
}

