/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class UpgradeProcess
extends BaseDBProcess
implements UpgradeStep {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeProcess.class);
    private static final Set<String> _portal62TableNames = new HashSet<String>(Arrays.asList("account_", "address", "announcementsdelivery", "announcementsentry", "announcementsflag", "assetcategory", "assetcategoryproperty", "assetentries_assetcategories", "assetentries_assettags", "assetentry", "assetlink", "assettag", "assettagstats", "assetvocabulary", "backgroundtask", "blogsentry", "blogsstatsuser", "bookmarksentry", "bookmarksfolder", "browsertracker", "calevent", "classname_", "clustergroup", "company", "contact_", "counter", "country", "ddlrecord", "ddlrecordset", "ddlrecordversion", "ddmcontent", "ddmstoragelink", "ddmstructure", "ddmstructurelink", "ddmtemplate", "dlcontent", "dlfileentry", "dlfileentrymetadata", "dlfileentrytype", "dlfileentrytypes_dlfolders", "dlfilerank", "dlfileshortcut", "dlfileversion", "dlfolder", "dlsyncevent", "emailaddress", "expandocolumn", "expandorow", "expandotable", "expandovalue", "exportimportconfiguration", "group_", "groups_orgs", "groups_roles", "groups_usergroups", "image", "journalarticle", "journalarticleimage", "journalarticleresource", "journalcontentsearch", "journalfeed", "journalfolder", "journalstructure", "journaltemplate", "layout", "layoutbranch", "layoutfriendlyurl", "layoutprototype", "layoutrevision", "layoutset", "layoutsetbranch", "layoutsetprototype", "listtype", "lock_", "mbban", "mbcategory", "mbdiscussion", "mbmailinglist", "mbmessage", "mbstatsuser", "mbthread", "mbthreadflag", "mdraction", "mdrrule", "mdrrulegroup", "mdrulegroupinstance", "membershiprequest", "organization_", "orggrouprole", "orglabor", "passwordpolicy", "passwordpolicyrel", "passwordtracker", "phone", "pluginsetting", "pollschoice", "pollsquestion", "pollsvote", "portalpreferences", "portlet", "portletitem", "portletpreferences", "ratingsentry", "ratingsstats", "recentlayoutbranch", "recentlayoutrevision", "recentlayoutsetbranch", "region", "release_", "repository", "repositoryentry", "resourceaction", "resourceblock", "resourceblockpermission", "resourcepermission", "resourcetypepermission", "role_", "servicecomponent", "socialactivity", "socialactivityachievement", "socialactivitycounter", "socialactivitylimit", "socialactivityset", "socialactivitysetting", "socialrelation", "socialrequest", "subscription", "systemevent", "team", "ticket", "trashentry", "trashversion", "usernotificationdelivery", "user_", "usergroup", "usergroupgrouprole", "usergrouprole", "usergroups_teams", "useridmapper", "usernotificationevent", "users_groups", "users_orgs", "users_roles", "users_teams", "users_usergroups", "usertracker", "usertrackerpath", "virtualhost", "webdavprops", "website", "wikinode", "wikipage", "wikipageresource", "workflowdefinitionlink", "workflowinstancelink"));
    private static final Map<String, List<ObjectValuePair<String, IndexMetadata>>> _portalIndexesSQL = new HashMap<String, List<ObjectValuePair<String, IndexMetadata>>>();

    public void clearIndexesCache() {
        _portalIndexesSQL.clear();
    }

    public int getThreshold() {
        return 0;
    }

    /*
     * Exception decompiling
     */
    public void upgrade() throws UpgradeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public void upgrade(Class<?> upgradeProcessClass) throws UpgradeException {
        UpgradeProcess upgradeProcess = null;
        try {
            upgradeProcess = (UpgradeProcess)upgradeProcessClass.newInstance();
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
        upgradeProcess.upgrade();
    }

    @Override
    public void upgrade(DBProcessContext dbProcessContext) throws UpgradeException {
        this.upgrade();
    }

    public void upgrade(UpgradeProcess upgradeProcess) throws UpgradeException {
        upgradeProcess.upgrade();
    }

    protected void alter(Class<?> tableClass, Alterable ... alterables) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String tableName = this.getTableName(tableClass);
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            DBInspector dbInspector = new DBInspector(this.connection);
            try (ResultSet rs1 = databaseMetaData.getPrimaryKeys(dbInspector.getCatalog(), dbInspector.getSchema(), tableName);
                 ResultSet rs2 = databaseMetaData.getIndexInfo(dbInspector.getCatalog(), dbInspector.getSchema(), dbInspector.normalizeName(tableName), false, false);){
                HashSet<String> primaryKeyNames = new HashSet<String>();
                while (rs1.next()) {
                    String primaryKeyName = StringUtil.toUpperCase(rs1.getString("PK_NAME"));
                    if (primaryKeyName == null) continue;
                    primaryKeyNames.add(primaryKeyName);
                }
                HashMap<String, HashSet<String>> columnNamesMap = new HashMap<String, HashSet<String>>();
                while (rs2.next()) {
                    String indexName = StringUtil.toUpperCase(rs2.getString("INDEX_NAME"));
                    if (indexName == null || primaryKeyNames.contains(indexName)) continue;
                    HashSet<String> columnNames = (HashSet<String>)columnNamesMap.get(indexName);
                    if (columnNames == null) {
                        columnNames = new HashSet<String>();
                        columnNamesMap.put(indexName, columnNames);
                    }
                    columnNames.add(StringUtil.toUpperCase(rs2.getString("COLUMN_NAME")));
                }
                for (Alterable alterable : alterables) {
                    for (Map.Entry entry : columnNamesMap.entrySet()) {
                        if (!alterable.shouldDropIndex((Collection)entry.getValue())) continue;
                        this.runSQL(StringBundler.concat("drop index ", (String)entry.getKey(), " on ", tableName));
                    }
                    this.runSQL(alterable.getSQL(tableName));
                    List<ObjectValuePair<String, IndexMetadata>> objectValuePairs = this.getIndexesSQL(tableClass.getClassLoader(), tableName);
                    if (objectValuePairs == null) continue;
                    for (ObjectValuePair<String, IndexMetadata> objectValuePair : objectValuePairs) {
                        IndexMetadata indexMetadata = objectValuePair.getValue();
                        if (!alterable.shouldAddIndex(Arrays.asList(indexMetadata.getColumnNames()))) continue;
                        this.runSQLTemplateString(objectValuePair.getKey(), false, true);
                    }
                }
            }
            catch (SQLException sqle) {
                if (_log.isWarnEnabled()) {
                    _log.warn(StringBundler.concat("Attempting to upgrade table ", tableName, " by recreating the table due to: ", sqle.getMessage()));
                }
                Field tableColumnsField = tableClass.getField("TABLE_COLUMNS");
                Field tableSQLCreateField = tableClass.getField("TABLE_SQL_CREATE");
                Field tableSQLAddIndexesField = tableClass.getField("TABLE_SQL_ADD_INDEXES");
                this.upgradeTable(tableName, (Object[][])tableColumnsField.get(null), (String)tableSQLCreateField.get(null), (String[])tableSQLAddIndexesField.get(null), new UpgradeColumn[0]);
                if (_log.isWarnEnabled()) {
                    _log.warn("Successfully recreated and upgraded table " + tableName);
                }
            }
        }
    }

    protected abstract void doUpgrade() throws Exception;

    protected List<ObjectValuePair<String, IndexMetadata>> getIndexesSQL(ClassLoader classLoader, String tableName) throws IOException {
        if (!PortalClassLoaderUtil.isPortalClassLoader(classLoader)) {
            try (InputStream is = classLoader.getResourceAsStream("META-INF/sql/indexes.sql");){
                if (is == null) {
                    List<ObjectValuePair<String, IndexMetadata>> list = null;
                    return list;
                }
                ArrayList<ObjectValuePair<String, IndexMetadata>> objectValuePairs = new ArrayList<ObjectValuePair<String, IndexMetadata>>();
                try (InputStreamReader reader = new InputStreamReader(is);
                     UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
                    String line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        IndexMetadata indexMetadata;
                        if ((line = line.trim()).isEmpty() || !tableName.equals((indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata(line)).getTableName())) continue;
                        objectValuePairs.add(new ObjectValuePair<String, IndexMetadata>(line, indexMetadata));
                    }
                }
                ArrayList<ObjectValuePair<String, IndexMetadata>> arrayList = objectValuePairs;
                return arrayList;
            }
        }
        if (!_portalIndexesSQL.isEmpty()) {
            return _portalIndexesSQL.get(tableName);
        }
        try (InputStream is = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/indexes.sql");
             InputStreamReader reader = new InputStreamReader(is);
             UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata(line);
                List<ObjectValuePair<String, IndexMetadata>> objectValuePairs = _portalIndexesSQL.get(indexMetadata.getTableName());
                if (objectValuePairs == null) {
                    objectValuePairs = new ArrayList<ObjectValuePair<String, IndexMetadata>>();
                    _portalIndexesSQL.put(indexMetadata.getTableName(), objectValuePairs);
                }
                objectValuePairs.add(new ObjectValuePair<String, IndexMetadata>(line, indexMetadata));
            }
        }
        return _portalIndexesSQL.get(tableName);
    }

    protected Map<String, Integer> getTableColumnsMap(Class<?> tableClass) throws Exception {
        Field tableNameField = tableClass.getField("TABLE_COLUMNS_MAP");
        return (Map)tableNameField.get(null);
    }

    protected String getTableName(Class<?> tableClass) throws Exception {
        Field tableNameField = tableClass.getField("TABLE_NAME");
        return (String)tableNameField.get(null);
    }

    protected long increment() {
        DB db = DBManagerUtil.getDB();
        return db.increment();
    }

    protected long increment(String name) {
        DB db = DBManagerUtil.getDB();
        return db.increment(name);
    }

    protected long increment(String name, int size) {
        DB db = DBManagerUtil.getDB();
        return db.increment(name, size);
    }

    protected boolean isPortal62TableName(String tableName) {
        return _portal62TableNames.contains(StringUtil.toLowerCase(tableName));
    }

    protected boolean isSkipUpgradeProcess() throws Exception {
        return false;
    }

    protected boolean isSupportsAlterColumnName() {
        DB db = DBManagerUtil.getDB();
        return db.isSupportsAlterColumnName();
    }

    protected boolean isSupportsAlterColumnType() {
        DB db = DBManagerUtil.getDB();
        return db.isSupportsAlterColumnType();
    }

    protected boolean isSupportsStringCaseSensitiveQuery() {
        DB db = DBManagerUtil.getDB();
        return db.isSupportsStringCaseSensitiveQuery();
    }

    protected boolean isSupportsUpdateWithInnerJoin() {
        DB db = DBManagerUtil.getDB();
        return db.isSupportsUpdateWithInnerJoin();
    }

    @Deprecated
    protected String normalizeName(String name, DatabaseMetaData databaseMetaData) throws SQLException {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.normalizeName(name, databaseMetaData);
    }

    protected void upgradeTable(String tableName, Object[][] tableColumns) throws Exception {
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable(tableName, tableColumns, new UpgradeColumn[0]);
        upgradeTable.updateTable();
    }

    protected void upgradeTable(String tableName, Object[][] tableColumns, String createSQL, String[] indexesSQL, UpgradeColumn ... upgradeColumns) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable(tableName, tableColumns, upgradeColumns);
            upgradeTable.setCreateSQL(createSQL);
            upgradeTable.setIndexesSQL(indexesSQL);
            upgradeTable.updateTable();
        }
    }

    public class AlterTableDropColumn
    implements Alterable {
        private final String _columnName;

        public AlterTableDropColumn(String columnName) {
            this._columnName = columnName;
        }

        @Override
        @Deprecated
        public String getIndexedColumnName() {
            return null;
        }

        @Override
        public String getSQL(String tableName) {
            StringBundler sb = new StringBundler(4);
            sb.append("alter table ");
            sb.append(tableName);
            sb.append(" drop column ");
            sb.append(this._columnName);
            return sb.toString();
        }

        @Override
        public boolean shouldAddIndex(Collection<String> columnNames) {
            return false;
        }

        @Override
        public boolean shouldDropIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._columnName);
        }
    }

    public class AlterTableAddColumn
    implements Alterable {
        private final String _columnName;

        public AlterTableAddColumn(String columnName) {
            this._columnName = columnName;
        }

        @Override
        @Deprecated
        public String getIndexedColumnName() {
            return null;
        }

        @Override
        public String getSQL(String tableName) {
            StringBundler sb = new StringBundler(4);
            sb.append("alter table ");
            sb.append(tableName);
            sb.append(" add ");
            sb.append(this._columnName);
            return sb.toString();
        }

        @Override
        public boolean shouldAddIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._columnName);
        }

        @Override
        public boolean shouldDropIndex(Collection<String> columnNames) {
            return false;
        }
    }

    public class AlterColumnType
    implements Alterable {
        private final String _columnName;
        private final String _newType;

        public AlterColumnType(String columnName, String newType) {
            this._columnName = columnName;
            this._newType = newType;
        }

        @Override
        @Deprecated
        public String getIndexedColumnName() {
            return null;
        }

        @Override
        public String getSQL(String tableName) {
            StringBundler sb = new StringBundler(6);
            sb.append("alter_column_type ");
            sb.append(tableName);
            sb.append(" ");
            sb.append(this._columnName);
            sb.append(" ");
            sb.append(this._newType);
            return sb.toString();
        }

        @Override
        public boolean shouldAddIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._columnName);
        }

        @Override
        public boolean shouldDropIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._columnName);
        }
    }

    public class AlterColumnName
    implements Alterable {
        private final String _newColumn;
        private final String _newColumnName;
        private final String _oldColumnName;

        public AlterColumnName(String oldColumnName, String newColumn) {
            this._oldColumnName = oldColumnName;
            this._newColumn = newColumn;
            String newColumnName = StringUtil.extractFirst(newColumn, " ");
            this._newColumnName = newColumnName != null ? newColumnName : this._newColumn;
        }

        @Override
        @Deprecated
        public String getIndexedColumnName() {
            return null;
        }

        @Override
        public String getSQL(String tableName) {
            StringBundler sb = new StringBundler(6);
            sb.append("alter_column_name ");
            sb.append(tableName);
            sb.append(" ");
            sb.append(this._oldColumnName);
            sb.append(" ");
            sb.append(this._newColumn);
            return sb.toString();
        }

        @Override
        public boolean shouldAddIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._newColumnName);
        }

        @Override
        public boolean shouldDropIndex(Collection<String> columnNames) {
            return Alterable.containsIgnoreCase(columnNames, this._oldColumnName);
        }
    }

    public static interface Alterable {
        public static boolean containsIgnoreCase(Collection<String> columnNames, String columnName) {
            for (String curColumnName : columnNames) {
                if (!StringUtil.equalsIgnoreCase(curColumnName, columnName)) continue;
                return true;
            }
            return false;
        }

        @Deprecated
        public String getIndexedColumnName();

        public String getSQL(String var1);

        public boolean shouldAddIndex(Collection<String> var1);

        public boolean shouldDropIndex(Collection<String> var1);
    }
}

