/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public abstract class BaseUpgradeDBColumnSize
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeDBColumnSize.class);
    private final DBType _dbType;
    private final String _oldColumnType;
    private final int _size;

    public BaseUpgradeDBColumnSize(DBType dbType, String oldColumnType, int size) {
        this._dbType = dbType;
        this._oldColumnType = oldColumnType;
        this._size = size;
    }

    @Override
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == this._dbType) {
            this._upgradeTables();
        }
    }

    protected abstract void upgradeColumn(String var1, String var2) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _upgradeTables() throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             ResultSet tableRS = databaseMetaData.getTables(catalog, schema, null, new String[]{"TABLE"});){
            while (tableRS.next()) {
                ResultSet columnRS;
                block65: {
                    String tableName = dbInspector.normalizeName(tableRS.getString("TABLE_NAME"));
                    HashSet<String> invalidColumnNames = new HashSet<String>();
                    try (ResultSet primaryKeyRS = databaseMetaData.getPrimaryKeys(catalog, schema, tableName);){
                        while (primaryKeyRS.next()) {
                            String primaryKeyName = StringUtil.toUpperCase(primaryKeyRS.getString("COLUMN_NAME"));
                            invalidColumnNames.add(primaryKeyName);
                        }
                    }
                    var12_16 = null;
                    try (ResultSet indexRS = databaseMetaData.getIndexInfo(catalog, schema, tableName, false, false);){
                        while (indexRS.next()) {
                            invalidColumnNames.add(StringUtil.toUpperCase(indexRS.getString("COLUMN_NAME")));
                        }
                    }
                    catch (Throwable primaryKeyName) {
                        var12_16 = primaryKeyName;
                        throw primaryKeyName;
                    }
                    columnRS = databaseMetaData.getColumns(catalog, schema, tableName, null);
                    var12_16 = null;
                    try {
                        while (columnRS.next()) {
                            String columnName;
                            int size = columnRS.getInt("COLUMN_SIZE");
                            if (size != this._size || !StringUtil.equalsIgnoreCase(this._oldColumnType, columnRS.getString("TYPE_NAME")) || invalidColumnNames.contains(StringUtil.toUpperCase(columnName = columnRS.getString("COLUMN_NAME")))) continue;
                            try {
                                this.upgradeColumn(tableName, columnName);
                            }
                            catch (SQLException sqle) {
                                if (!_log.isWarnEnabled()) continue;
                                _log.warn(StringBundler.concat("Unable to alter length of column ", columnName, " for table ", tableName), sqle);
                            }
                        }
                        if (columnRS == null) continue;
                        if (var12_16 == null) break block65;
                    }
                    catch (Throwable throwable) {
                        try {
                            var12_16 = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (columnRS == null) throw throwable2;
                            if (var12_16 != null) {
                                try {
                                    columnRS.close();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    var12_16.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                            }
                            columnRS.close();
                            throw throwable2;
                        }
                    }
                    try {
                        columnRS.close();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var12_16.addSuppressed(throwable);
                        continue;
                    }
                }
                columnRS.close();
            }
            return;
        }
    }
}

