/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;

public class UserTestUtil {
    public static User addCompanyAdminUser(Company company) throws Exception {
        User user = UserTestUtil.addUser(company);
        Role role = RoleLocalServiceUtil.getRole(company.getCompanyId(), "Administrator");
        UserLocalServiceUtil.addRoleUser(role.getRoleId(), user);
        return user;
    }

    public static User addGroupAdminUser(Group group) throws Exception {
        return UserTestUtil.addGroupUser(group, "Site Administrator");
    }

    public static User addGroupOwnerUser(Group group) throws Exception {
        return UserTestUtil.addGroupUser(group, "Site Owner");
    }

    public static User addGroupUser(Group group, String roleName) throws Exception {
        User groupUser = UserTestUtil.addUser(group.getGroupId());
        Role role = RoleLocalServiceUtil.getRole(group.getCompanyId(), roleName);
        long[] userIds = new long[]{groupUser.getUserId()};
        UserGroupRoleLocalServiceUtil.addUserGroupRoles(userIds, group.getGroupId(), role.getRoleId());
        return groupUser;
    }

    public static User addOmniAdminUser() throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyByMx(PropsUtil.get("company.default.web.id"));
        return UserTestUtil.addCompanyAdminUser(company);
    }

    public static User addOrganizationAdminUser(Organization organization) throws Exception {
        return UserTestUtil.addOrganizationUser(organization, "Organization Administrator");
    }

    public static User addOrganizationOwnerUser(Organization organization) throws Exception {
        return UserTestUtil.addOrganizationUser(organization, "Organization Owner");
    }

    public static User addOrganizationUser(Organization organization, String roleName) throws Exception {
        User organizationUser = UserTestUtil.addUser(organization.getGroupId());
        UserLocalServiceUtil.addOrganizationUser(organization.getOrganizationId(), organizationUser.getUserId());
        UserTestUtil.addUserGroupRole(organizationUser.getUserId(), organization.getGroupId(), roleName);
        return organizationUser;
    }

    public static User addUser() throws Exception {
        return UserTestUtil.addUser(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE), LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), new long[]{TestPropsValues.getGroupId()}, ServiceContextTestUtil.getServiceContext());
    }

    public static User addUser(boolean secure) throws Exception {
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        long facebookId = 0L;
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = "UserServiceTest";
        String middleName = "";
        String lastName = "UserServiceTest";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendMail = false;
        ServiceContext serviceContext = new ServiceContext();
        if (secure) {
            String emailAddress = "UserServiceTest." + RandomTestUtil.nextLong() + "@liferay.com";
            return UserServiceUtil.addUser(TestPropsValues.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendMail, serviceContext);
        }
        String emailAddress = "UserServiceTest." + RandomTestUtil.nextLong() + "@test.com";
        return UserLocalServiceUtil.addUser(TestPropsValues.getUserId(), TestPropsValues.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendMail, serviceContext);
    }

    public static User addUser(Company company) throws Exception {
        return UserTestUtil.addUser(company.getCompanyId(), TestPropsValues.getUserId(), RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE), LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), new long[]{TestPropsValues.getGroupId()}, ServiceContextTestUtil.getServiceContext());
    }

    public static User addUser(long ... groupIds) throws Exception {
        return UserTestUtil.addUser(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE), LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), groupIds, ServiceContextTestUtil.getServiceContext());
    }

    public static User addUser(long groupId, Locale locale) throws Exception {
        return UserTestUtil.addUser(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE), locale, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), new long[]{groupId}, ServiceContextTestUtil.getServiceContext());
    }

    public static User addUser(long companyId, long userId, String screenName, Locale locale, String firstName, String lastName, long[] groupIds, ServiceContext serviceContext) throws Exception {
        String emailAddress = RandomTestUtil.randomString(new RandomizerBumper[0]) + RandomTestUtil.nextLong() + "@liferay.com";
        return UserTestUtil.addUser(companyId, userId, "", emailAddress, screenName, locale, firstName, lastName, groupIds, serviceContext);
    }

    public static User addUser(long companyId, long userId, String password, String emailAddress, String screenName, Locale locale, String firstName, String lastName, long[] groupIds, ServiceContext serviceContext) throws Exception {
        User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, screenName);
        if (user != null) {
            return user;
        }
        boolean autoPassword = true;
        String password1 = password;
        String password2 = password;
        long facebookId = 0L;
        String openId = "";
        String middleName = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendMail = false;
        return UserLocalServiceUtil.addUser(userId, companyId, autoPassword, password1, password2, Validator.isNull(screenName), screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendMail, serviceContext);
    }

    public static User addUser(String screenName, Locale locale, String firstName, String lastName, long[] groupIds) throws Exception {
        return UserTestUtil.addUser(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), screenName, locale, firstName, lastName, groupIds, ServiceContextTestUtil.getServiceContext());
    }

    public static User addUser(String screenName, long ... groupIds) throws Exception {
        return UserTestUtil.addUser(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), screenName, LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), groupIds, ServiceContextTestUtil.getServiceContext());
    }

    public static void addUserGroupRole(long userId, long groupId, String roleName) throws Exception {
        Role role = RoleLocalServiceUtil.getRole(TestPropsValues.getCompanyId(), roleName);
        UserGroupRoleLocalServiceUtil.addUserGroupRoles(new long[]{userId}, groupId, role.getRoleId());
    }

    public static User getAdminUser(long companyId) throws PortalException {
        Role role = RoleLocalServiceUtil.getRole(companyId, "Administrator");
        List<User> users = UserLocalServiceUtil.getRoleUsers(role.getRoleId(), 0, 1);
        if (!users.isEmpty()) {
            return users.get(0);
        }
        return null;
    }

    public static User updateUser(User user) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        return UserTestUtil.updateUser(user, serviceContext);
    }

    public static User updateUser(User user, ServiceContext serviceContext) throws Exception {
        String oldPassword = "";
        String newPassword1 = "";
        String newPassword2 = "";
        Boolean passwordReset = false;
        String reminderQueryQuestion = "";
        String reminderQueryAnswer = "";
        String screenName = "TestUser" + RandomTestUtil.nextLong();
        String emailAddress = "UserServiceTest." + RandomTestUtil.nextLong() + "@liferay.com";
        long facebookId = 0L;
        String openId = "";
        String languageId = "";
        String timeZoneId = "";
        String greeting = "";
        String comments = "";
        String firstName = "UserServiceTest";
        String middleName = "";
        String lastName = "UserServiceTest";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String smsSn = "";
        String facebookSn = "";
        String jabberSn = "";
        String skypeSn = "";
        String twitterSn = "";
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List<UserGroupRole> userGroupRoles = null;
        long[] userGroupIds = null;
        return UserServiceUtil.updateUser(user.getUserId(), oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
    }
}

