/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.test.util.TestPropsUtil;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;

public class TestPropsValues {
    public static final boolean ASSERT_LOGS = GetterUtil.getBoolean(TestPropsUtil.get("assert.logs"));
    public static final long CI_TEST_TIMEOUT_TIME = GetterUtil.getLong(TestPropsUtil.get("ci.test.timeout.time"), 2400000L);
    public static final String COMPANY_WEB_ID;
    public static final boolean DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY;
    public static final int JUNIT_DELAY_FACTOR;
    public static final String PORTAL_URL;
    public static final String USER_PASSWORD;
    private static long _companyId;
    private static long _groupId;
    private static long _plid;
    private static User _user;
    private static long _userId;

    public static long getCompanyId() throws PortalException {
        if (_companyId > 0L) {
            return _companyId;
        }
        Company company = CompanyLocalServiceUtil.getCompanyByWebId(COMPANY_WEB_ID);
        _companyId = company.getCompanyId();
        return _companyId;
    }

    public static long getGroupId() throws PortalException {
        if (_groupId > 0L) {
            return _groupId;
        }
        Group group = GroupLocalServiceUtil.getGroup(TestPropsValues.getCompanyId(), "Guest");
        _groupId = group.getGroupId();
        return _groupId;
    }

    public static long getPlid() throws PortalException {
        return TestPropsValues.getPlid(TestPropsValues.getGroupId());
    }

    public static long getPlid(long groupId) {
        if (_plid > 0L) {
            return _plid;
        }
        _plid = LayoutLocalServiceUtil.getDefaultPlid(groupId);
        return _plid;
    }

    public static User getUser() throws PortalException {
        if (_user == null) {
            _user = UserTestUtil.getAdminUser(TestPropsValues.getCompanyId());
        }
        return _user;
    }

    public static long getUserId() throws PortalException {
        User user;
        if (_userId == 0L && (user = TestPropsValues.getUser()) != null) {
            _userId = user.getUserId();
        }
        return _userId;
    }

    static {
        DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY = GetterUtil.getBoolean(TestPropsUtil.get("dl.file.entry.processors.trigger.synchronously"));
        JUNIT_DELAY_FACTOR = GetterUtil.getInteger(TestPropsUtil.get("junit.delay.factor"));
        PORTAL_URL = TestPropsUtil.get("portal.url");
        USER_PASSWORD = TestPropsUtil.get("user.password");
        String companyWebId = TestPropsUtil.get("company.web.id");
        try {
            if (Validator.isNull(companyWebId)) {
                companyWebId = GetterUtil.getString(PropsUtil.get("company.default.web.id"));
                TestPropsUtil.set("company.web.id", companyWebId);
            }
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError(e);
        }
        TestPropsUtil.printProperties();
        COMPANY_WEB_ID = companyWebId;
    }
}

