/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;

public class ServiceContextTestUtil {
    public static ServiceContext getServiceContext() throws PortalException {
        return ServiceContextTestUtil.getServiceContext(TestPropsValues.getGroupId());
    }

    public static ServiceContext getServiceContext(Group group, long userId) {
        return ServiceContextTestUtil.getServiceContext(group.getCompanyId(), group.getGroupId(), userId);
    }

    public static ServiceContext getServiceContext(long groupId) throws PortalException {
        if (groupId == TestPropsValues.getGroupId()) {
            return ServiceContextTestUtil.getServiceContext(groupId, TestPropsValues.getUserId());
        }
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        User user = UserTestUtil.getAdminUser(group.getCompanyId());
        return ServiceContextTestUtil.getServiceContext(group, user.getUserId());
    }

    public static ServiceContext getServiceContext(long groupId, long userId) throws PortalException {
        if (groupId == TestPropsValues.getGroupId()) {
            return ServiceContextTestUtil.getServiceContext(TestPropsValues.getCompanyId(), groupId, userId);
        }
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        return ServiceContextTestUtil.getServiceContext(group.getCompanyId(), group.getGroupId(), userId);
    }

    public static ServiceContext getServiceContext(long companyId, long groupId, long userId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(companyId);
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        return serviceContext;
    }
}

