/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;

public class RoleTestUtil {
    public static long addGroupRole(long groupId) throws Exception {
        Role role = RoleTestUtil.addRole(2);
        RoleLocalServiceUtil.addGroupRole(groupId, role.getRoleId());
        return role.getRoleId();
    }

    public static long addOrganizationRole(long groupId) throws Exception {
        Role role = RoleTestUtil.addRole(3);
        RoleLocalServiceUtil.addGroupRole(groupId, role.getRoleId());
        return role.getRoleId();
    }

    public static long addRegularRole(long groupId) throws Exception {
        Role role = RoleTestUtil.addRole(1);
        RoleLocalServiceUtil.addGroupRole(groupId, role.getRoleId());
        return role.getRoleId();
    }

    public static void addResourcePermission(Role role, String resourceName, int scope, String primKey, String actionId) throws Exception {
        ResourcePermissionLocalServiceUtil.addResourcePermission(role.getCompanyId(), resourceName, scope, primKey, role.getRoleId(), actionId);
    }

    public static void addResourcePermission(String roleName, String resourceName, int scope, String primKey, String actionId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole(TestPropsValues.getCompanyId(), roleName);
        RoleTestUtil.addResourcePermission(role, resourceName, scope, primKey, actionId);
    }

    public static Role addRole(int roleType) throws Exception {
        return RoleTestUtil.addRole(RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE), roleType);
    }

    public static Role addRole(String roleName, int roleType) throws Exception {
        Role role = null;
        try {
            role = RoleLocalServiceUtil.getRole(TestPropsValues.getCompanyId(), roleName);
        }
        catch (NoSuchRoleException nsre) {
            role = RoleLocalServiceUtil.addRole(TestPropsValues.getUserId(), null, 0L, roleName, null, null, roleType, null, null);
        }
        return role;
    }

    public static Role addRole(String roleName, int roleType, String resourceName, int scope, String primKey, String actionId) throws Exception {
        Role role = RoleTestUtil.addRole(roleName, roleType);
        RoleTestUtil.addResourcePermission(role, resourceName, scope, primKey, actionId);
        return role;
    }

    public static void removeResourcePermission(String roleName, String resourceName, int scope, String primKey, String actionId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole(TestPropsValues.getCompanyId(), roleName);
        ResourcePermissionLocalServiceUtil.removeResourcePermission(role.getCompanyId(), resourceName, scope, primKey, role.getRoleId(), actionId);
    }
}

