/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class RandomTestUtil {
    private static final int _RANDOMIZER_BUMPER_TRIES_MAX = 100;
    private static final Random _random = new Random();

    public static Date nextDate() {
        return new Date();
    }

    public static double nextDouble() {
        return CounterLocalServiceUtil.increment();
    }

    public static int nextInt() {
        return (int)CounterLocalServiceUtil.increment();
    }

    public static long nextLong() {
        return CounterLocalServiceUtil.increment();
    }

    public static boolean randomBoolean() {
        return _random.nextBoolean();
    }

    public static double randomDouble() {
        double value = _random.nextDouble();
        if (value > 0.0) {
            return value;
        }
        if (value == 0.0) {
            return RandomTestUtil.randomDouble();
        }
        return -value;
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        return (T)enumConstants[_random.nextInt(enumConstants.length)];
    }

    public static int randomInt() {
        return RandomTestUtil.randomInt(1, Integer.MAX_VALUE);
    }

    public static int randomInt(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Max value must be greater than or equal to the min value");
        }
        int value = _random.nextInt();
        long range = max + 1 - min;
        if (range == 0L) {
            return value;
        }
        return (int)((long)Math.abs(value) % range + (long)min);
    }

    public static Map<Locale, String> randomLocaleStringMap() {
        return RandomTestUtil.randomLocaleStringMap(LocaleUtil.getDefault());
    }

    public static Map<Locale, String> randomLocaleStringMap(Locale locale) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        map.put(LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]));
        return map;
    }

    public static long randomLong() {
        long value = _random.nextLong();
        if (value > 0L) {
            return value;
        }
        if (value == 0L) {
            return RandomTestUtil.randomLong();
        }
        return -value;
    }

    @SafeVarargs
    public static String randomString(int length, RandomizerBumper<String> ... randomizerBumpers) {
        block0: for (int i = 0; i < 100; ++i) {
            String randomString = PwdGenerator.getPassword(length);
            for (RandomizerBumper<String> randomizerBumper : randomizerBumpers) {
                if (!randomizerBumper.accept(randomString)) continue block0;
            }
            return randomString;
        }
        throw new IllegalStateException(StringBundler.concat("Unable to generate a random string that is acceptable by all ", "randomizer bumpers ", Arrays.toString(randomizerBumpers), " after ", 100, " tries"));
    }

    @SafeVarargs
    public static String randomString(RandomizerBumper<String> ... randomizerBumpers) {
        return RandomTestUtil.randomString(8, randomizerBumpers);
    }

    @SafeVarargs
    public static String[] randomStrings(int count, RandomizerBumper<String> ... randomizerBumpers) {
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = RandomTestUtil.randomString(randomizerBumpers);
        }
        return strings;
    }

    public static UnicodeProperties randomUnicodeProperties(int propertyCount, int keyLength, int valueLength) {
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        for (int i = 0; i < propertyCount; ++i) {
            unicodeProperties.put(RandomTestUtil.randomString(keyLength, new RandomizerBumper[0]), RandomTestUtil.randomString(valueLength, new RandomizerBumper[0]));
        }
        return unicodeProperties;
    }
}

