/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactoryUtil;
import com.liferay.exportimport.kernel.service.StagingLocalServiceUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GroupTestUtil {
    public static Group addGroup() throws Exception {
        return GroupTestUtil.addGroup(0L);
    }

    public static Group addGroup(long parentGroupId) throws Exception {
        return GroupTestUtil.addGroup(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), parentGroupId);
    }

    public static Group addGroup(long userId, Layout layout) throws Exception {
        return GroupTestUtil.addGroup(userId, 0L, layout);
    }

    public static Group addGroup(long userId, long parentGroupId, Layout layout) throws Exception {
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            return scopeGroup;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), String.valueOf(layout.getPlid()));
        return GroupLocalServiceUtil.addGroup(userId, parentGroupId, Layout.class.getName(), layout.getPlid(), 0L, nameMap, null, 0, true, 0, null, false, true, null);
    }

    public static Group addGroup(long companyId, long userId, long parentGroupId) throws Exception {
        String name = RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE);
        Group group = GroupLocalServiceUtil.fetchGroup(companyId, name);
        if (group != null) {
            return group;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]));
        int type = 1;
        String friendlyURL = "/" + FriendlyURLNormalizerUtil.normalize(name);
        boolean site = true;
        boolean active = true;
        boolean manualMembership = true;
        int membershipRestriction = 0;
        return GroupLocalServiceUtil.addGroup(userId, parentGroupId, null, 0L, 0L, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, active, ServiceContextTestUtil.getServiceContext());
    }

    public static Group addGroup(long parentGroupId, ServiceContext serviceContext) throws Exception {
        String name = RandomTestUtil.randomString(NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE);
        return GroupTestUtil.addGroup(parentGroupId, name, serviceContext);
    }

    public static Group addGroup(long parentGroupId, String name, ServiceContext serviceContext) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup(TestPropsValues.getCompanyId(), name);
        if (group != null) {
            return group;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getDefault(), RandomTestUtil.randomString(new RandomizerBumper[0]));
        int type = 1;
        String friendlyURL = "/" + FriendlyURLNormalizerUtil.normalize(name);
        boolean site = true;
        boolean active = true;
        boolean manualMembership = true;
        int membershipRestriction = 0;
        if (serviceContext == null) {
            serviceContext = ServiceContextTestUtil.getServiceContext();
        }
        return GroupServiceUtil.addGroup(parentGroupId, 0L, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, active, serviceContext);
    }

    public static Group deleteGroup(Group group) throws Exception {
        return GroupLocalServiceUtil.deleteGroup(group);
    }

    public static void enableLocalStaging(Group group) throws Exception {
        GroupTestUtil.enableLocalStaging(group, TestPropsValues.getUserId());
    }

    public static void enableLocalStaging(Group group, long userId) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(group.getGroupId());
        Map<String, Serializable> attributes = serviceContext.getAttributes();
        attributes.putAll(ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap());
        attributes.put("PORTLET_CONFIGURATION_ALL", (Serializable)new String[]{Boolean.FALSE.toString()});
        attributes.put("PORTLET_DATA_ALL", (Serializable)new String[]{Boolean.FALSE.toString()});
        StagingLocalServiceUtil.enableLocalStaging(userId, group, false, false, serviceContext);
    }

    public static Group updateDisplaySettings(long groupId, Collection<Locale> availableLocales, Locale defaultLocale) throws Exception {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        boolean inheritLocales = false;
        if (availableLocales == null && defaultLocale == null) {
            inheritLocales = true;
        }
        typeSettingsProperties.put("inheritLocales", String.valueOf(inheritLocales));
        if (availableLocales != null) {
            typeSettingsProperties.put("locales", StringUtil.merge(LocaleUtil.toLanguageIds(availableLocales)));
        }
        if (defaultLocale != null) {
            typeSettingsProperties.put("languageId", LocaleUtil.toLanguageId(defaultLocale));
        }
        Group group = GroupLocalServiceUtil.updateGroup(groupId, typeSettingsProperties.toString());
        ThreadLocalCacheManager.clearAll(Lifecycle.REQUEST);
        return group;
    }
}

