/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class CompanyTestUtil {
    public static Company addCompany() throws Exception {
        return CompanyTestUtil.addCompany(RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static Company addCompany(String name) throws Exception {
        String virtualHostname = name + "." + RandomTestUtil.randomString(3, new RandomizerBumper[0]);
        return CompanyLocalServiceUtil.addCompany(name, virtualHostname, virtualHostname, false, 0, true);
    }

    public static void resetCompanyLocales(long companyId, Collection<Locale> locales, Locale defaultLocale) throws Exception {
        String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
        String languageIds = StringUtil.merge(LocaleUtil.toLanguageIds(locales));
        CompanyTestUtil.resetCompanyLocales(companyId, languageIds, defaultLanguageId);
    }

    public static void resetCompanyLocales(long companyId, String languageIds, String defaultLanguageId) throws Exception {
        User user = UserLocalServiceUtil.loadGetDefaultUser(companyId);
        user.setLanguageId(defaultLanguageId);
        TimeZone timeZone = TimeZoneUtil.getDefault();
        user.setTimeZoneId(timeZone.getID());
        UserLocalServiceUtil.updateUser(user);
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        preferences.setValue("locales", languageIds);
        preferences.store();
        LanguageUtil.resetAvailableLocales(companyId);
        CompanyThreadLocal.setCompanyId(companyId);
        LocaleThreadLocal.setDefaultLocale(LocaleUtil.fromLanguageId(defaultLanguageId));
    }
}

