/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.test.rule.StatementWrapper;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.ThreadUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TimeoutTestRule
implements TestRule {
    public static final TimeoutTestRule INSTANCE = new TimeoutTestRule(TestPropsValues.CI_TEST_TIMEOUT_TIME);
    public static final int TIMEOUT_EXIT_CODE = 200;
    private final long _timeout;

    public TimeoutTestRule(long timeout) {
        this._timeout = timeout;
    }

    @Override
    public Statement apply(Statement statement, final Description description) {
        String methodName = description.getMethodName();
        if (methodName == null || !OSDetector.isLinux() && !OSDetector.isUnix()) {
            return statement;
        }
        return new StatementWrapper(statement){

            @Override
            public void evaluate() throws Throwable {
                FutureTask<Void> futureTask = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws InterruptedException {
                        Thread.sleep(TimeoutTestRule.this._timeout);
                        StringBundler sb = new StringBundler(6);
                        sb.append("Thread dump for ");
                        sb.append(description.toString());
                        sb.append(" timeout after waited ");
                        sb.append(TimeoutTestRule.this._timeout);
                        sb.append("ms:");
                        sb.append(ThreadUtil.threadDump());
                        System.out.println(sb.toString());
                        System.exit(200);
                        return null;
                    }
                });
                Thread timeoutMonitoringThread = new Thread(futureTask, "Timeout monitoring thread for " + description.toString());
                timeoutMonitoringThread.start();
                try {
                    this.statement.evaluate();
                }
                finally {
                    futureTask.cancel(true);
                    timeoutMonitoringThread.join();
                }
            }
        };
    }
}

