/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.test.rule.AbstractTestRule;
import com.liferay.portal.kernel.test.rule.Sync;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.junit.runner.Description;

public class SynchronousDestinationTestRule
extends AbstractTestRule<SyncHandler, SyncHandler> {
    public static final SynchronousDestinationTestRule INSTANCE = new SynchronousDestinationTestRule();
    private static final TransactionConfig _transactionConfig;

    @Override
    public void afterClass(Description description, SyncHandler syncHandler) throws Exception {
        if (syncHandler != null) {
            syncHandler.restorePreviousSync();
        }
    }

    @Override
    public void afterMethod(Description description, SyncHandler syncHandler, Object target) {
        if (syncHandler != null) {
            syncHandler.restorePreviousSync();
        }
    }

    @Override
    public SyncHandler beforeClass(Description description) throws Throwable {
        Class<?> testClass = description.getTestClass();
        return this._createSyncHandler(testClass.getAnnotation(Sync.class));
    }

    @Override
    public SyncHandler beforeMethod(Description description, Object target) {
        Class<?> testClass = description.getTestClass();
        Sync sync = testClass.getAnnotation(Sync.class);
        if (sync != null) {
            return null;
        }
        sync = description.getAnnotation(Sync.class);
        if (sync == null) {
            return null;
        }
        return this._createSyncHandler(sync);
    }

    protected SynchronousDestinationTestRule() {
    }

    private SyncHandler _createSyncHandler(Sync sync) {
        SyncHandler syncHandler = new SyncHandler();
        syncHandler.setForceSync(ProxyModeThreadLocal.isForceSync());
        syncHandler.setSync(sync);
        syncHandler.enableSync();
        return syncHandler;
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.NOT_SUPPORTED);
        builder.setRollbackForClasses(PortalException.class, SystemException.class);
        _transactionConfig = builder.build();
    }

    private static class CleanTransactionSynchronousDestination
    extends SynchronousDestination {
        private CleanTransactionSynchronousDestination() {
        }

        @Override
        public void send(final Message message) {
            try {
                TransactionInvokerUtil.invoke(_transactionConfig, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CleanTransactionSynchronousDestination.super.send(message);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static class SyncHandler {
        private final List<String> _absentDestinationNames = new ArrayList<String>();
        private final List<Destination> _asyncServiceDestinations = new ArrayList<Destination>();
        private boolean _forceSync;
        private final List<InvokerMessageListener> _schedulerInvokerMessageListeners = new ArrayList<InvokerMessageListener>();
        private Sync _sync;

        public BaseDestination createSynchronousDestination(String destinationName) {
            SynchronousDestination synchronousDestination = null;
            synchronousDestination = this._sync != null && this._sync.cleanTransaction() ? new CleanTransactionSynchronousDestination() : new SynchronousDestination();
            synchronousDestination.setName(destinationName);
            return synchronousDestination;
        }

        public void enableSync() {
            ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
            Filter asyncFilter = this._registerDestinationFilter("liferay/async_service");
            Filter backgroundTaskFilter = this._registerDestinationFilter("liferay/background_task");
            Filter backgroundTaskStatusFilter = this._registerDestinationFilter("liferay/background_task_status");
            Filter mailFilter = this._registerDestinationFilter("liferay/mail");
            Filter pdfProcessorFilter = this._registerDestinationFilter("liferay/document_library_pdf_processor");
            Filter rawMetaDataProcessorFilter = this._registerDestinationFilter("liferay/document_library_raw_metadata_processor");
            Filter subscrpitionSenderFilter = this._registerDestinationFilter("liferay/subscription_sender");
            serviceDependencyManager.registerDependencies(asyncFilter, backgroundTaskFilter, backgroundTaskStatusFilter, mailFilter, pdfProcessorFilter, rawMetaDataProcessorFilter, subscrpitionSenderFilter);
            boolean schedulerEnabled = GetterUtil.getBoolean(PropsUtil.get("scheduler.enabled"));
            if (schedulerEnabled) {
                String[] kaleoGraphWalkerFilter = this._registerDestinationFilter("liferay/kaleo_graph_walker");
                serviceDependencyManager.registerDependencies(new Filter[]{kaleoGraphWalkerFilter});
            }
            serviceDependencyManager.waitForDependencies();
            ProxyModeThreadLocal.setForceSync(true);
            this.replaceDestination("liferay/async_service");
            this.replaceDestination("liferay/background_task");
            this.replaceDestination("liferay/background_task_status");
            this.replaceDestination("liferay/document_library_pdf_processor");
            this.replaceDestination("liferay/document_library_raw_metadata_processor");
            this.replaceDestination("liferay/document_library_sync_event_processor");
            this.replaceDestination("liferay/mail");
            this.replaceDestination("liferay/scheduler_engine");
            this.replaceDestination("liferay/subscription_sender");
            this.replaceDestination("liferay/adaptive_media_processor");
            this.replaceDestination("liferay/asset_auto_tagger");
            this.replaceDestination("liferay/report_request");
            this.replaceDestination("liferay/reports_admin");
            if (this._sync != null) {
                for (String name : this._sync.destinationNames()) {
                    this.replaceDestination(name);
                }
            }
            if (schedulerEnabled) {
                this.replaceDestination("liferay/kaleo_graph_walker");
            }
            for (String searchEngineId : SearchEngineHelperUtil.getSearchEngineIds()) {
                this.replaceDestination(SearchEngineHelperUtil.getSearchReaderDestinationName(searchEngineId));
                this.replaceDestination(SearchEngineHelperUtil.getSearchWriterDestinationName(searchEngineId));
            }
            MessageBus messageBus = MessageBusUtil.getMessageBus();
            BaseAsyncDestination schedulerDestination = (BaseAsyncDestination)messageBus.getDestination("liferay/scheduler_dispatch");
            if (schedulerDestination == null) {
                return;
            }
            for (MessageListener messageListener : schedulerDestination.getMessageListeners()) {
                InvokerMessageListener invokerMessageListener = (InvokerMessageListener)messageListener;
                MessageListener schedulerMessageListener = invokerMessageListener.getMessageListener();
                schedulerDestination.unregister(schedulerMessageListener);
                this._schedulerInvokerMessageListeners.add(invokerMessageListener);
            }
            CountDownLatch startCountDownLatch = new CountDownLatch(schedulerDestination.getWorkersMaxSize());
            CountDownLatch endCountDownLatch = new CountDownLatch(1);
            Message countDownMessage = new Message();
            MessageListener messageListener = message -> {
                if (countDownMessage == message) {
                    startCountDownLatch.countDown();
                    try {
                        endCountDownLatch.await();
                    }
                    catch (InterruptedException ie) {
                        ReflectionUtil.throwException(ie);
                    }
                }
            };
            schedulerDestination.register(messageListener);
            for (int i = 0; i < schedulerDestination.getWorkersMaxSize(); ++i) {
                schedulerDestination.send(countDownMessage);
            }
            try {
                startCountDownLatch.await();
            }
            catch (InterruptedException ie) {
                ReflectionUtil.throwException(ie);
            }
            schedulerDestination.unregister(messageListener);
            endCountDownLatch.countDown();
        }

        public void replaceDestination(String destinationName) {
            MessageBus messageBus = MessageBusUtil.getMessageBus();
            Destination destination = messageBus.getDestination(destinationName);
            if (destination instanceof BaseAsyncDestination) {
                this._asyncServiceDestinations.add(destination);
                messageBus.replace(this.createSynchronousDestination(destinationName), false);
            }
            if (destination == null) {
                this._absentDestinationNames.add(destinationName);
                messageBus.addDestination(this.createSynchronousDestination(destinationName));
            }
        }

        public void restorePreviousSync() {
            ProxyModeThreadLocal.setForceSync(this._forceSync);
            MessageBus messageBus = MessageBusUtil.getMessageBus();
            for (Destination destination : this._asyncServiceDestinations) {
                messageBus.replace(destination);
            }
            this._asyncServiceDestinations.clear();
            for (String absentDestinationName : this._absentDestinationNames) {
                messageBus.removeDestination(absentDestinationName);
            }
            Destination destination = messageBus.getDestination("liferay/scheduler_dispatch");
            if (destination == null) {
                return;
            }
            for (InvokerMessageListener invokerMessageListener : this._schedulerInvokerMessageListeners) {
                destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
            }
        }

        public void setForceSync(boolean forceSync) {
            this._forceSync = forceSync;
        }

        public void setSync(Sync sync) {
            this._sync = sync;
        }

        private Filter _registerDestinationFilter(String destinationName) {
            Registry registry = RegistryUtil.getRegistry();
            return registry.getFilter(StringBundler.concat("(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"));
        }
    }
}

