/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ClassPathUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.process.local.LocalProcessExecutor;
import com.liferay.petra.process.local.LocalProcessLauncher;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.test.rule.NewEnv;
import com.liferay.portal.kernel.test.rule.StatementWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Before;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NewEnvTestRule
implements TestRule {
    public static final NewEnvTestRule INSTANCE = new NewEnvTestRule();
    protected static final String CLASS_PATH = ClassPathUtil.getJVMClassPath(true);
    private static final String _JPDA_OPTIONS = "-agentlib:jdwp=transport=dt_socket,address=8001,server=y,suspend=y";
    private static final ProcessExecutor _processExecutor = new LocalProcessExecutor();
    private static final Pattern _systemPropertyReplacePattern = Pattern.compile("\\$\\{(.*)\\}");

    @Override
    public Statement apply(Statement statement, Description description) {
        String methodName = description.getMethodName();
        if (methodName == null) {
            return statement;
        }
        NewEnv newEnv = this.findNewEnv(description);
        if (newEnv == null || newEnv.type() == NewEnv.Type.NONE) {
            return statement;
        }
        if (NewEnv.Type.CLASSLOADER == newEnv.type()) {
            return new RunInNewClassLoaderStatement(statement, description);
        }
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        builder.setArguments(this.createArguments(description));
        builder.setBootstrapClassPath(CLASS_PATH);
        builder.setRuntimeClassPath(CLASS_PATH);
        this.setEnvironment(builder, description);
        return new RunInNewJVMStatment(builder.build(), statement, description);
    }

    protected static void attachProcess(String message) {
        if (Boolean.getBoolean("attached")) {
            return;
        }
        LocalProcessLauncher.ProcessContext.attach(message, 1000L, new LocalProcessLauncher.ShutdownHook(){

            @Override
            public boolean shutdown(int shutdownCode, Throwable shutdownThrowable) {
                System.exit(shutdownCode);
                return true;
            }
        });
        System.setProperty("attached", "true");
    }

    protected static List<MethodKey> getMethodKeys(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        TestClass testClass = new TestClass(targetClass);
        List<FrameworkMethod> frameworkMethods = testClass.getAnnotatedMethods(annotationClass);
        ArrayList<MethodKey> methodKeys = new ArrayList<MethodKey>(frameworkMethods.size());
        for (FrameworkMethod annotatedFrameworkMethod : frameworkMethods) {
            methodKeys.add(new MethodKey(annotatedFrameworkMethod.getMethod()));
        }
        return methodKeys;
    }

    protected static void invoke(ClassLoader classLoader, MethodKey methodKey, Object object) throws Exception {
        methodKey = methodKey.transform(classLoader);
        Method method = methodKey.getMethod();
        method.invoke(object, new Object[0]);
    }

    protected NewEnvTestRule() {
    }

    protected List<String> createArguments(Description description) {
        String fileName;
        ArrayList<String> arguments = new ArrayList<String>();
        Class<?> testClass = description.getTestClass();
        NewEnv.JVMArgsLine jvmArgsLine = testClass.getAnnotation(NewEnv.JVMArgsLine.class);
        if (jvmArgsLine != null) {
            arguments.addAll(this.processJVMArgsLine(jvmArgsLine));
        }
        if ((jvmArgsLine = description.getAnnotation(NewEnv.JVMArgsLine.class)) != null) {
            arguments.addAll(this.processJVMArgsLine(jvmArgsLine));
        }
        arguments.add("-Djava.net.preferIPv4Stack=true");
        if (this._isJPDAEnabled()) {
            arguments.add(_JPDA_OPTIONS);
            arguments.add("-Djvm.debug=true");
        }
        arguments.add("-Dliferay.mode=test");
        arguments.add("-Dsun.zip.disableMemoryMapping=true");
        String whipAgentLine = System.getProperty("whip.agent");
        if (Validator.isNotNull(whipAgentLine)) {
            arguments.add(whipAgentLine);
            arguments.add("-Dwhip.agent=" + whipAgentLine);
        }
        if ((fileName = System.getProperty("whip.datafile")) != null) {
            arguments.add("-Dwhip.datafile=" + fileName);
        }
        if (Boolean.getBoolean("whip.instrument.dump")) {
            arguments.add("-Dwhip.instrument.dump=true");
        }
        if (Boolean.getBoolean("whip.static.instrument")) {
            arguments.add("-Dwhip.static.instrument=true");
        }
        return arguments;
    }

    protected ClassLoader createClassLoader(Description description) {
        try {
            return new URLClassLoader(ClassPathUtil.getClassPathURLs(CLASS_PATH), null);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException(murle);
        }
    }

    protected NewEnv findNewEnv(Description description) {
        NewEnv newEnv = description.getAnnotation(NewEnv.class);
        if (newEnv == null) {
            Class<?> testClass = description.getTestClass();
            newEnv = testClass.getAnnotation(NewEnv.class);
        }
        return newEnv;
    }

    protected Map<String, String> processEnvironmentVariables(String[] variables) {
        HashMap<String, String> environmentMap = new HashMap<String, String>();
        for (String variable : variables) {
            String resolvedVariable = this.resolveSystemProperty(variable);
            String[] parts = StringUtil.split(resolvedVariable, '=');
            if (parts.length != 2) {
                throw new IllegalArgumentException(StringBundler.concat("Wrong environment variable ", variable, " resolved as ", resolvedVariable, ". Need to be \"key=value\" format"));
            }
            environmentMap.put(parts[0], parts[1]);
        }
        return environmentMap;
    }

    protected List<String> processJVMArgsLine(NewEnv.JVMArgsLine jvmArgsLine) {
        String[] jvmArgs = StringUtil.split(jvmArgsLine.value(), " ");
        ArrayList<String> jvmArgsList = new ArrayList<String>(jvmArgs.length);
        for (String jvmArg : jvmArgs) {
            jvmArgsList.add(this.resolveSystemProperty(jvmArg));
        }
        return jvmArgsList;
    }

    protected ProcessCallable<Serializable> processProcessCallable(ProcessCallable<Serializable> processCallable, MethodKey testMethodKey) {
        return processCallable;
    }

    protected String resolveSystemProperty(String value) {
        Matcher matcher = _systemPropertyReplacePattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(GetterUtil.getString(System.getProperty(key))));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected void setEnvironment(ProcessConfig.Builder builder, Description description) {
        Map<String, String> map;
        Map<String, String> environmentMap = new HashMap<String, String>(System.getenv());
        Class<?> testClass = description.getTestClass();
        NewEnv.Environment environment = testClass.getAnnotation(NewEnv.Environment.class);
        if (environment != null) {
            map = this.processEnvironmentVariables(environment.variables());
            if (environment.append()) {
                environmentMap.putAll(map);
            } else {
                environmentMap = map;
            }
        }
        if ((environment = description.getAnnotation(NewEnv.Environment.class)) != null) {
            map = this.processEnvironmentVariables(environment.variables());
            if (environment.append()) {
                environmentMap.putAll(map);
            } else {
                environmentMap = map;
            }
        }
        builder.setEnvironment(environmentMap);
    }

    private boolean _isJPDAEnabled() {
        if (Boolean.getBoolean("jvm.debug")) {
            return true;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String argument : runtimeMXBean.getInputArguments()) {
            if (!argument.startsWith("-agentlib:jdwp=")) continue;
            return true;
        }
        return false;
    }

    static {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        PortalClassLoaderUtil.setClassLoader(contextClassLoader);
    }

    private class RunInNewJVMStatment
    extends StatementWrapper {
        private final List<MethodKey> _afterMethodKeys;
        private final List<MethodKey> _beforeMethodKeys;
        private final ProcessConfig _processConfig;
        private final String _testClassName;
        private final MethodKey _testMethodKey;

        public RunInNewJVMStatment(ProcessConfig processConfig, Statement statement, Description description) {
            super(statement);
            this._processConfig = processConfig;
            Class<?> testClass = description.getTestClass();
            this._afterMethodKeys = NewEnvTestRule.getMethodKeys(testClass, After.class);
            this._beforeMethodKeys = NewEnvTestRule.getMethodKeys(testClass, Before.class);
            this._testClassName = testClass.getName();
            this._testMethodKey = new MethodKey(testClass, description.getMethodName(), new Class[0]);
        }

        @Override
        public void evaluate() throws Throwable {
            ProcessCallable<Serializable> processCallable = new TestProcessCallable(this._testClassName, this._beforeMethodKeys, this._testMethodKey, this._afterMethodKeys);
            processCallable = NewEnvTestRule.this.processProcessCallable(processCallable, this._testMethodKey);
            ProcessChannel<Serializable> processChannel = _processExecutor.execute(this._processConfig, processCallable);
            NoticeableFuture<Serializable> future = processChannel.getProcessNoticeableFuture();
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                while (cause instanceof InvocationTargetException || cause instanceof ProcessException) {
                    cause = cause.getCause();
                }
                throw cause;
            }
        }
    }

    private class RunInNewClassLoaderStatement
    extends StatementWrapper {
        private final List<MethodKey> _afterMethodKeys;
        private final List<MethodKey> _beforeMethodKeys;
        private final ClassLoader _newClassLoader;
        private final String _testClassName;
        private final MethodKey _testMethodKey;

        public RunInNewClassLoaderStatement(Statement statement, Description description) {
            super(statement);
            Class<?> testClass = description.getTestClass();
            this._afterMethodKeys = NewEnvTestRule.getMethodKeys(testClass, After.class);
            this._beforeMethodKeys = NewEnvTestRule.getMethodKeys(testClass, Before.class);
            this._newClassLoader = NewEnvTestRule.this.createClassLoader(description);
            this._testClassName = testClass.getName();
            this._testMethodKey = new MethodKey(testClass, description.getMethodName(), new Class[0]);
        }

        @Override
        public void evaluate() throws Throwable {
            MethodKey.resetCache();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this._newClassLoader);
            String quiet = System.getProperty("system.properties.quiet");
            System.setProperty("system.properties.quiet", "true");
            try {
                Class<?> clazz = this._newClassLoader.loadClass(this._testClassName);
                Object object = clazz.newInstance();
                for (MethodKey beforeMethodKey : this._beforeMethodKeys) {
                    NewEnvTestRule.invoke(this._newClassLoader, beforeMethodKey, object);
                }
                NewEnvTestRule.invoke(this._newClassLoader, this._testMethodKey, object);
                for (MethodKey afterMethodKey : this._afterMethodKeys) {
                    NewEnvTestRule.invoke(this._newClassLoader, afterMethodKey, object);
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            finally {
                if (quiet == null) {
                    System.clearProperty("system.properties.quiet");
                } else {
                    System.setProperty("system.properties.quiet", quiet);
                }
                currentThread.setContextClassLoader(contextClassLoader);
                MethodKey.resetCache();
            }
        }
    }

    private static class TestProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final List<MethodKey> _afterMethodKeys;
        private final List<MethodKey> _beforeMethodKeys;
        private final String _testClassName;
        private final MethodKey _testMethodKey;

        public TestProcessCallable(String testClassName, List<MethodKey> beforeMethodKeys, MethodKey testMethodKey, List<MethodKey> afterMethodKeys) {
            this._testClassName = testClassName;
            this._beforeMethodKeys = beforeMethodKeys;
            this._testMethodKey = testMethodKey;
            this._afterMethodKeys = afterMethodKeys;
        }

        @Override
        public Serializable call() throws ProcessException {
            NewEnvTestRule.attachProcess("Attached " + this.toString());
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            System.setProperty("system.properties.quiet", "true");
            try {
                Class<?> clazz = contextClassLoader.loadClass(this._testClassName);
                Object object = clazz.newInstance();
                for (MethodKey beforeMethodKey : this._beforeMethodKeys) {
                    NewEnvTestRule.invoke(contextClassLoader, beforeMethodKey, object);
                }
                NewEnvTestRule.invoke(contextClassLoader, this._testMethodKey, object);
                for (MethodKey afterMethodKey : this._afterMethodKeys) {
                    NewEnvTestRule.invoke(contextClassLoader, afterMethodKey, object);
                }
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
            return "";
        }

        public String toString() {
            StringBundler sb = new StringBundler(4);
            sb.append(this._testClassName);
            sb.append(".");
            sb.append(this._testMethodKey.getMethodName());
            sb.append("()");
            return sb.toString();
        }
    }
}

