/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.petra.process.EchoOutputProcessor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.test.GCUtil;
import com.liferay.portal.kernel.util.HeapUtil;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class HeapDumpTestRule
implements TestRule {
    public static final HeapDumpTestRule INSTANCE = new HeapDumpTestRule(true);
    private final boolean _live;

    public HeapDumpTestRule(boolean live) {
        this._live = live;
    }

    @Override
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                Date date = new Date();
                GCUtil.fullGC(HeapDumpTestRule.this._live);
                Future<Map.Entry<Void, Void>> future = HeapUtil.heapDump(HeapDumpTestRule.this._live, true, StringBundler.concat(description.toString(), "-", date, "-before.bin"), EchoOutputProcessor.INSTANCE);
                future.get();
                try {
                    statement.evaluate();
                }
                catch (Throwable throwable) {
                    GCUtil.fullGC(HeapDumpTestRule.this._live);
                    future = HeapUtil.heapDump(HeapDumpTestRule.this._live, true, StringBundler.concat(description.toString(), "-", date, "-after.bin"), EchoOutputProcessor.INSTANCE);
                    future.get();
                    throw throwable;
                }
                GCUtil.fullGC(HeapDumpTestRule.this._live);
                future = HeapUtil.heapDump(HeapDumpTestRule.this._live, true, StringBundler.concat(description.toString(), "-", date, "-after.bin"), EchoOutputProcessor.INSTANCE);
                future.get();
            }
        };
    }
}

