/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.rule;

import com.liferay.portal.kernel.test.rule.StatementWrapper;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AbstractTestRule<C, M>
implements TestRule {
    @Override
    public Statement apply(Statement statement, Description description) {
        if (description.getMethodName() != null) {
            return this.createMethodStatement(statement, description);
        }
        return this.createClassStatement(statement, description);
    }

    protected abstract void afterClass(Description var1, C var2) throws Throwable;

    protected abstract void afterMethod(Description var1, M var2, Object var3) throws Throwable;

    protected abstract C beforeClass(Description var1) throws Throwable;

    protected abstract M beforeMethod(Description var1, Object var2) throws Throwable;

    protected Statement createClassStatement(Statement statement, final Description description) {
        return new StatementWrapper(statement){

            @Override
            public void evaluate() throws Throwable {
                Object c = AbstractTestRule.this.beforeClass(description);
                try {
                    this.statement.evaluate();
                }
                finally {
                    AbstractTestRule.this.afterClass(description, c);
                }
            }
        };
    }

    protected Statement createMethodStatement(Statement statement, final Description description) {
        return new StatementWrapper(statement){

            @Override
            public void evaluate() throws Throwable {
                Object target = this.inspectTarget(this.statement);
                Object m = AbstractTestRule.this.beforeMethod(description, target);
                try {
                    this.statement.evaluate();
                }
                finally {
                    AbstractTestRule.this.afterMethod(description, m, target);
                }
            }
        };
    }
}

