/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test.context;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;

public class ContextUserReplace
implements AutoCloseable {
    private final String _name = PrincipalThreadLocal.getName();
    private final PermissionChecker _permissionChecker = PermissionThreadLocal.getPermissionChecker();

    public ContextUserReplace(User user) throws Exception {
        this(user, PermissionCheckerFactoryUtil.create(user));
    }

    public ContextUserReplace(User user, PermissionChecker permissionChecker) {
        PrincipalThreadLocal.setName(user.getUserId());
        PermissionThreadLocal.setPermissionChecker(permissionChecker);
    }

    @Override
    public void close() {
        PrincipalThreadLocal.setName(this._name);
        PermissionThreadLocal.setPermissionChecker(this._permissionChecker);
    }
}

