/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.junit.Assert;

public class GCUtil {
    public static void fullGC(boolean ensureEnqueuedReferences) throws InterruptedException {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        SoftReference<Object> softReference = new SoftReference<Object>(new Object(), referenceQueue);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            while (true) {
                list.add(new byte[0x6400000]);
            }
        }
        catch (OutOfMemoryError oome) {
            list.clear();
            list = null;
            Assert.assertNull(softReference.get());
            Assert.assertSame(softReference, referenceQueue.remove());
            if (ensureEnqueuedReferences) {
                GCUtil.fullGC(false);
            }
            return;
        }
    }

    public static void gc(boolean ensureEnqueuedReferences) throws InterruptedException {
        GCUtil.gc(true, ensureEnqueuedReferences);
    }

    public static void gc(boolean actively, boolean ensureEnqueuedReferences) throws InterruptedException {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object(), referenceQueue);
        if (actively) {
            while (weakReference.get() != null) {
                System.gc();
                System.runFinalization();
            }
        }
        Assert.assertSame(weakReference, referenceQueue.remove());
        if (ensureEnqueuedReferences) {
            GCUtil.gc(actively, false);
        }
    }
}

