/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.petra.string.StringBundler;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CaptureHandler
extends Handler
implements Closeable {
    private final Handler[] _handlers;
    private final Level _level;
    private final Logger _logger;
    private final List<LogRecord> _logRecords = new CopyOnWriteArrayList<LogRecord>();
    private final boolean _useParentHandlers;

    public CaptureHandler(Logger logger, Level level) {
        this._logger = logger;
        this._handlers = logger.getHandlers();
        this._level = logger.getLevel();
        this._useParentHandlers = logger.getUseParentHandlers();
        for (Handler handler : this._handlers) {
            logger.removeHandler(handler);
        }
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
    }

    @Override
    public void close() {
        this._logRecords.clear();
        this._logger.removeHandler(this);
        for (Handler handler : this._handlers) {
            this._logger.addHandler(handler);
        }
        this._logger.setLevel(this._level);
        this._logger.setUseParentHandlers(this._useParentHandlers);
    }

    @Override
    public void flush() {
        this._logRecords.clear();
    }

    public List<LogRecord> getLogRecords() {
        return this._logRecords;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return false;
    }

    @Override
    public void publish(LogRecord logRecord) {
        this._logRecords.add(new PrintableLogRecord(logRecord));
    }

    public List<LogRecord> resetLogLevel(Level level) {
        this._logRecords.clear();
        this._logger.setLevel(level);
        return this._logRecords;
    }

    private static class PrintableLogRecord
    extends LogRecord {
        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{level=");
            sb.append(this.getLevel());
            sb.append(", message=");
            sb.append(this.getMessage());
            sb.append("}");
            return sb.toString();
        }

        private PrintableLogRecord(LogRecord logRecord) {
            super(logRecord.getLevel(), logRecord.getMessage());
            this.setLoggerName(logRecord.getLoggerName());
            this.setMillis(logRecord.getMillis());
            this.setParameters(logRecord.getParameters());
            this.setResourceBundle(logRecord.getResourceBundle());
            this.setResourceBundleName(logRecord.getResourceBundleName());
            this.setSequenceNumber(logRecord.getSequenceNumber());
            this.setSourceClassName(logRecord.getSourceClassName());
            this.setSourceMethodName(logRecord.getSourceMethodName());
            this.setThreadID(logRecord.getThreadID());
            this.setThrown(logRecord.getThrown());
        }
    }
}

