/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.social;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import java.util.Date;

public abstract class BaseSocialActivityManager<T extends ClassedModel & GroupedModel>
implements SocialActivityManager<T> {
    @Override
    public void addActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        if (type == 10002) {
            if (primaryKey != ((GroupedModel)model).getGroupId()) {
                this.getSocialActivityLocalService().addActivity(userId, ((GroupedModel)model).getGroupId(), className, primaryKey, 10002, extraData, 0L);
            }
        } else {
            this.getSocialActivityLocalService().addActivity(userId, ((GroupedModel)model).getGroupId(), className, primaryKey, type, extraData, receiverUserId);
        }
    }

    @Override
    public void addUniqueActivity(long userId, Date createDate, T model, int type, String extraData, long receiverUserId) throws PortalException {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        this.getSocialActivityLocalService().addUniqueActivity(userId, ((GroupedModel)model).getGroupId(), createDate, className, primaryKey, type, extraData, receiverUserId);
    }

    @Override
    public void addUniqueActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        this.getSocialActivityLocalService().addUniqueActivity(userId, ((GroupedModel)model).getGroupId(), className, primaryKey, type, extraData, receiverUserId);
    }

    @Override
    public void deleteActivities(T model) throws PortalException {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        this.getSocialActivityLocalService().deleteActivities(className, primaryKey);
    }

    @Override
    public void updateLastSocialActivity(long userId, T model, int type, Date createDate) {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        SocialActivity lastSocialActivity = this.getSocialActivityLocalService().fetchFirstActivity(className, primaryKey, type);
        if (lastSocialActivity != null) {
            lastSocialActivity.setUserId(userId);
            lastSocialActivity.setCreateDate(createDate.getTime());
            this.getSocialActivityLocalService().updateSocialActivity(lastSocialActivity);
        }
    }

    protected String getClassName(T classedModel) {
        return classedModel.getModelClassName();
    }

    protected long getPrimaryKey(T classedModel) {
        if (!(classedModel.getPrimaryKeyObj() instanceof Long)) {
            throw new IllegalArgumentException("Only models with a primary key of type Long can make use of SocialActivityManagers");
        }
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected abstract SocialActivityLocalService getSocialActivityLocalService();
}

