/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.PrefsPropsUtil;

public class PortletInstanceSettingsLocator
implements SettingsLocator {
    private final String _configurationPid;
    private Boolean _embeddedPortlet;
    private final Layout _layout;
    private final String _portletInstanceKey;

    public PortletInstanceSettingsLocator(Layout layout, String portletInstanceKey) {
        this(layout, portletInstanceKey, PortletIdCodec.decodePortletName(portletInstanceKey));
    }

    public PortletInstanceSettingsLocator(Layout layout, String portletInstanceKey, String configurationPid) {
        this._layout = layout;
        this._portletInstanceKey = portletInstanceKey;
        this._configurationPid = configurationPid;
    }

    public String getConfigurationPid() {
        return this._configurationPid;
    }

    public long getOwnerId() {
        if (this.isEmbeddedPortlet()) {
            return this._layout.getGroupId();
        }
        return 0L;
    }

    public long getPlid() {
        if (this.isEmbeddedPortlet()) {
            return 0L;
        }
        return this._layout.getPlid();
    }

    @Override
    public Settings getSettings() throws SettingsException {
        SystemSettingsLocator systemSettingsLocator = new SystemSettingsLocator(this._configurationPid);
        PortletPreferencesSettings portalPreferencesSettings = new PortletPreferencesSettings(PrefsPropsUtil.getPreferences(this._layout.getCompanyId()), systemSettingsLocator.getSettings());
        return PortletPreferencesLocalServiceUtil.getPortletInstanceSettings(this._layout.getCompanyId(), this._layout.getGroupId(), this._portletInstanceKey, this, portalPreferencesSettings);
    }

    @Override
    public String getSettingsId() {
        return this._portletInstanceKey;
    }

    @Deprecated
    protected long getCompanyId(long groupId) {
        return this._layout.getCompanyId();
    }

    protected boolean isEmbeddedPortlet() {
        if (this._embeddedPortlet != null) {
            return this._embeddedPortlet;
        }
        this._embeddedPortlet = false;
        if (this._layout.isSupportsEmbeddedPortlets()) {
            this._embeddedPortlet = this._layout.isPortletEmbedded(this._portletInstanceKey, this._layout.getGroupId());
        }
        return this._embeddedPortlet;
    }
}

