/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicIncludeUtil {
    private static final Log _log = LogFactoryUtil.getLog(DynamicIncludeUtil.class);
    private static final DynamicIncludeUtil _instance = new DynamicIncludeUtil();
    private final ServiceTrackerMap<String, List<DynamicInclude>> _dynamicIncludes = ServiceTrackerCollections.openMultiValueMap(DynamicInclude.class, null, new ServiceReferenceMapper<String, DynamicInclude>(){

        @Override
        public void map(ServiceReference<DynamicInclude> serviceReference, final ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            DynamicInclude dynamicInclude = registry.getService(serviceReference);
            dynamicInclude.register(new DynamicInclude.DynamicIncludeRegistry(){

                @Override
                public void register(String key) {
                    emitter.emit(key);
                }
            });
            registry.ungetService(serviceReference);
        }
    });

    public static List<DynamicInclude> getDynamicIncludes(String key) {
        return DynamicIncludeUtil._instance._dynamicIncludes.getService(key);
    }

    public static boolean hasDynamicInclude(String key) {
        List<DynamicInclude> dynamicIncludes = DynamicIncludeUtil.getDynamicIncludes(key);
        return dynamicIncludes != null && !dynamicIncludes.isEmpty();
    }

    public static void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key, boolean ascendingPriority) {
        List<DynamicInclude> dynamicIncludes = DynamicIncludeUtil.getDynamicIncludes(key);
        if (dynamicIncludes == null || dynamicIncludes.isEmpty()) {
            return;
        }
        Iterator<DynamicInclude> iterator = null;
        iterator = ascendingPriority ? dynamicIncludes.iterator() : ListUtil.reverseIterator(dynamicIncludes);
        while (iterator.hasNext()) {
            DynamicInclude dynamicInclude = iterator.next();
            try {
                dynamicInclude.include(httpServletRequest, httpServletResponse, key);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    private DynamicIncludeUtil() {
    }
}

