/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.HttpOnlyCookieServletResponse;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.SanitizedServletResponse;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterHelper;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvokerFilter
extends BasePortalLifecycle
implements Filter {
    private static final boolean _INVOKER_FILTER_CHAIN_ENABLED = GetterUtil.getBoolean(PropsUtil.get("invoker.filter.chain.cache.enabled"));
    private static final int _INVOKER_FILTER_URI_MAX_LENGTH = GetterUtil.getInteger(PropsUtil.get("invoker.filter.uri.max.length"));
    private static final String _SECURE_RESPONSE = InvokerFilter.class.getName() + "SECURE_RESPONSE";
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilter.class);
    private String _contextPath;
    private Dispatcher _dispatcher;
    private PortalCache<String, InvokerFilterChain> _filterChains;
    private FilterConfig _filterConfig;
    private InvokerFilterHelper _invokerFilterHelper;

    public void destroy() {
        this.portalDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String originalURI = this.getOriginalRequestURI(httpServletRequest);
        if (!this.handleLongRequestURL(httpServletRequest, httpServletResponse, originalURI)) {
            return;
        }
        httpServletRequest = this.handleNonSerializableRequest(httpServletRequest);
        httpServletResponse = HttpOnlyCookieServletResponse.getHttpOnlyCookieServletResponse(httpServletResponse);
        httpServletResponse = this.secureResponseHeaders(httpServletRequest, httpServletResponse);
        String uri = this.getURI(originalURI);
        httpServletRequest.setAttribute("INVOKER_FILTER_URI", (Object)uri);
        try {
            InvokerFilterChain invokerFilterChain = this.getInvokerFilterChain(httpServletRequest, uri, filterChain);
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            invokerFilterChain.setContextClassLoader(contextClassLoader);
            invokerFilterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            httpServletRequest.removeAttribute("INVOKER_FILTER_URI");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        ServletContext servletContext = this._filterConfig.getServletContext();
        this._contextPath = servletContext.getContextPath();
        boolean registerPortalLifecycle = GetterUtil.getBoolean(this._filterConfig.getInitParameter("register-portal-lifecycle"), true);
        if (registerPortalLifecycle) {
            this.registerPortalLifecycle();
        } else {
            try {
                this.doPortalInit();
            }
            catch (Exception e) {
                _log.error(e, e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void clearFilterChainsCache() {
        if (this._filterChains != null) {
            this._filterChains.removeAll();
        }
    }

    @Override
    protected void doPortalDestroy() {
        ServletContext servletContext = this._filterConfig.getServletContext();
        InvokerFilterHelper invokerFilterHelper = (InvokerFilterHelper)servletContext.getAttribute(InvokerFilterHelper.class.getName());
        if (invokerFilterHelper != null) {
            servletContext.removeAttribute(InvokerFilterHelper.class.getName());
            invokerFilterHelper.destroy();
        }
        if (_INVOKER_FILTER_CHAIN_ENABLED) {
            PortalCacheHelperUtil.removePortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", this._getPortalCacheName());
        }
    }

    @Override
    protected void doPortalInit() throws Exception {
        ServletContext servletContext;
        InvokerFilterHelper invokerFilterHelper;
        if (_INVOKER_FILTER_CHAIN_ENABLED) {
            this._filterChains = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", this._getPortalCacheName());
        }
        if ((invokerFilterHelper = (InvokerFilterHelper)(servletContext = this._filterConfig.getServletContext()).getAttribute(InvokerFilterHelper.class.getName())) == null) {
            invokerFilterHelper = new InvokerFilterHelper();
            servletContext.setAttribute(InvokerFilterHelper.class.getName(), (Object)invokerFilterHelper);
            invokerFilterHelper.init(this._filterConfig);
        }
        this._invokerFilterHelper = invokerFilterHelper;
        this._invokerFilterHelper.addInvokerFilter(this);
        this._dispatcher = Dispatcher.valueOf(this._filterConfig.getInitParameter("dispatcher"));
    }

    protected InvokerFilterChain getInvokerFilterChain(HttpServletRequest httpServletRequest, String uri, FilterChain filterChain) {
        InvokerFilterChain invokerFilterChain;
        if (this._filterChains == null) {
            return this._invokerFilterHelper.createInvokerFilterChain(httpServletRequest, this._dispatcher, uri, filterChain);
        }
        String key = uri;
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNotNull(queryString)) {
            key = key.concat("?").concat(queryString);
        }
        if ((invokerFilterChain = this._filterChains.get(key)) == null) {
            invokerFilterChain = this._invokerFilterHelper.createInvokerFilterChain(httpServletRequest, this._dispatcher, uri, filterChain);
            this._filterChains.put(key, invokerFilterChain);
        }
        return invokerFilterChain.clone(filterChain);
    }

    protected String getOriginalRequestURI(HttpServletRequest httpServletRequest) {
        String uri = null;
        uri = this._dispatcher == Dispatcher.ERROR ? (String)httpServletRequest.getAttribute("javax.servlet.error.request_uri") : (this._dispatcher == Dispatcher.INCLUDE ? (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri") : httpServletRequest.getRequestURI());
        return uri;
    }

    @Deprecated
    protected String getURI(HttpServletRequest httpServletRequest, String originalURI) {
        return this.getURI(originalURI);
    }

    protected String getURI(String originalURI) {
        if (Validator.isNotNull(this._contextPath) && !this._contextPath.equals("/") && originalURI.startsWith(this._contextPath)) {
            originalURI = originalURI.substring(this._contextPath.length());
        }
        return HttpUtil.normalizePath(originalURI);
    }

    protected boolean handleLongRequestURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String originalURI) throws IOException {
        String queryString = httpServletRequest.getQueryString();
        int length = originalURI.length();
        if (queryString != null) {
            length += queryString.length();
        }
        if (length <= _INVOKER_FILTER_URI_MAX_LENGTH) {
            return true;
        }
        httpServletResponse.sendError(414);
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Rejected ");
            sb.append(StringUtil.shorten(originalURI, _INVOKER_FILTER_URI_MAX_LENGTH));
            sb.append(" because it has more than ");
            sb.append(_INVOKER_FILTER_URI_MAX_LENGTH);
            sb.append(" characters");
            _log.warn(sb.toString());
        }
        return false;
    }

    protected HttpServletRequest handleNonSerializableRequest(HttpServletRequest httpServletRequest) {
        if (ServerDetector.isWebLogic() && !NonSerializableObjectRequestWrapper.isWrapped(httpServletRequest)) {
            httpServletRequest = new NonSerializableObjectRequestWrapper((HttpServletRequest)httpServletRequest);
        }
        return httpServletRequest;
    }

    protected HttpServletResponse secureResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (Boolean.FALSE.equals(httpServletRequest.getAttribute(_SECURE_RESPONSE))) {
            return httpServletResponse;
        }
        httpServletRequest.setAttribute(_SECURE_RESPONSE, (Object)Boolean.FALSE);
        return SanitizedServletResponse.getSanitizedServletResponse(httpServletRequest, httpServletResponse);
    }

    private String _getPortalCacheName() {
        ServletContext servletContext = this._filterConfig.getServletContext();
        String servletContextName = servletContext.getContextPath();
        if (Validator.isNull(servletContextName)) {
            return this._filterConfig.getFilterName();
        }
        return StringBundler.concat(servletContextName, "-", this._filterConfig.getFilterName());
    }
}

