/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServletContextClassLoaderPool {
    private static final boolean _SERVLET_CONTEXT_CLASS_LOADER_POOL_FALLBACK = GetterUtil.getBoolean(PropsUtil.get("servlet.context.class.loader.pool.fallback"));
    private static final Map<String, ClassLoader> _classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private static final Map<ClassLoader, String> _servletContextNames = new ConcurrentHashMap<ClassLoader, String>();

    public static ClassLoader getClassLoader(String servletContextName) {
        ClassLoader classLoader;
        if (servletContextName != null && (classLoader = _classLoaders.get(servletContextName)) != null) {
            return classLoader;
        }
        if (_SERVLET_CONTEXT_CLASS_LOADER_POOL_FALLBACK) {
            return ClassLoaderPool.getClassLoader(servletContextName);
        }
        return null;
    }

    public static String getServletContextName(ClassLoader classLoader) {
        String servletContextName;
        if (classLoader != null && (servletContextName = _servletContextNames.get(classLoader)) != null) {
            return servletContextName;
        }
        if (_SERVLET_CONTEXT_CLASS_LOADER_POOL_FALLBACK) {
            return ClassLoaderPool.getContextName(classLoader);
        }
        return null;
    }

    public static void register(String servletContextName, ClassLoader classLoader) {
        _classLoaders.put(servletContextName, classLoader);
        _servletContextNames.put(classLoader, servletContextName);
    }

    public static void unregister(String servletContextName) {
        ClassLoader classLoader = _classLoaders.remove(servletContextName);
        if (classLoader != null) {
            _servletContextNames.remove(classLoader);
        }
    }
}

