/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PluginContextListener;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SecurePluginContextListener
extends PluginContextListener
implements HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionBindingListener,
HttpSessionListener,
ServletRequestAttributeListener,
ServletRequestListener {
    private static final Log _log = LogFactoryUtil.getLog(SecurePluginContextListener.class);
    private List<HttpSessionActivationListener> _httpSessionActivationListeners;
    private List<HttpSessionAttributeListener> _httpSessionAttributeListeners;
    private List<HttpSessionBindingListener> _httpSessionBindingListeners;
    private List<HttpSessionListener> _httpSessionListeners;
    private List<ServletContextListener> _servletContextListeners;
    private List<ServletRequestAttributeListener> _servletRequestAttributeListeners;
    private List<ServletRequestListener> _servletRequestListeners;

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this._httpSessionAttributeListeners == null) {
            return;
        }
        for (HttpSessionAttributeListener httpSessionAttributeListener : this._httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this._servletRequestAttributeListeners == null) {
            return;
        }
        for (ServletRequestAttributeListener servletRequestAttributeListener : this._servletRequestAttributeListeners) {
            servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this._httpSessionAttributeListeners == null) {
            return;
        }
        for (HttpSessionAttributeListener httpSessionAttributeListener : this._httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this._servletRequestAttributeListeners == null) {
            return;
        }
        for (ServletRequestAttributeListener servletRequestAttributeListener : this._servletRequestAttributeListeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this._httpSessionAttributeListeners == null) {
            return;
        }
        for (HttpSessionAttributeListener httpSessionAttributeListener : this._httpSessionAttributeListeners) {
            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (this._servletRequestAttributeListeners == null) {
            return;
        }
        for (ServletRequestAttributeListener servletRequestAttributeListener : this._servletRequestAttributeListeners) {
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        this.servletContext.setAttribute(SecurePluginContextListener.class.getName(), (Object)this);
        super.contextInitialized(servletContextEvent);
    }

    public void instantiatingListeners() throws Exception {
        String[] listenerClassNames;
        if (this._servletRequestListeners != null) {
            return;
        }
        for (String listenerClassName : listenerClassNames = StringUtil.split(this.servletContext.getInitParameter("portalListenerClasses"))) {
            this.instantiatingListener(listenerClassName);
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        if (this._servletRequestListeners == null) {
            return;
        }
        for (ServletRequestListener servletRequestListener : this._servletRequestListeners) {
            servletRequestListener.requestDestroyed(servletRequestEvent);
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        if (this._servletRequestListeners == null) {
            return;
        }
        for (ServletRequestListener servletRequestListener : this._servletRequestListeners) {
            servletRequestListener.requestInitialized(servletRequestEvent);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this._httpSessionListeners == null) {
            return;
        }
        for (HttpSessionListener httpSessionListener : this._httpSessionListeners) {
            httpSessionListener.sessionCreated(httpSessionEvent);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this._httpSessionListeners == null) {
            return;
        }
        for (HttpSessionListener httpSessionListener : this._httpSessionListeners) {
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
    }

    public void sessionDidActivate(HttpSessionEvent httpSessionEvent) {
        if (this._httpSessionActivationListeners == null) {
            return;
        }
        for (HttpSessionActivationListener httpSessionActivationListener : this._httpSessionActivationListeners) {
            httpSessionActivationListener.sessionDidActivate(httpSessionEvent);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent httpSessionEvent) {
        if (this._httpSessionActivationListeners == null) {
            return;
        }
        for (HttpSessionActivationListener httpSessionActivationListener : this._httpSessionActivationListeners) {
            httpSessionActivationListener.sessionWillPassivate(httpSessionEvent);
        }
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this._httpSessionBindingListeners == null) {
            return;
        }
        for (HttpSessionBindingListener httpSessionBindingListener : this._httpSessionBindingListeners) {
            httpSessionBindingListener.valueBound(httpSessionBindingEvent);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this._httpSessionBindingListeners == null) {
            return;
        }
        for (HttpSessionBindingListener httpSessionBindingListener : this._httpSessionBindingListeners) {
            httpSessionBindingListener.valueUnbound(httpSessionBindingEvent);
        }
    }

    @Override
    protected void fireUndeployEvent() {
        if (this._servletContextListeners != null) {
            ServletContextEvent servletContextEvent = new ServletContextEvent(this.servletContext);
            for (ServletContextListener servletContextListener : this._servletContextListeners) {
                try {
                    servletContextListener.contextDestroyed(servletContextEvent);
                }
                catch (Throwable t) {
                    String className = ClassUtil.getClassName(servletContextListener.getClass());
                    _log.error(StringBundler.concat(className, " is unable to process a context ", "destroyed event for ", this.servletContext.getServletContextName()), t);
                }
            }
        }
        super.fireUndeployEvent();
    }

    protected void instantiatingListener(String listenerClassName) throws Exception {
        Object listener;
        if (_log.isDebugEnabled()) {
            _log.debug("Instantiating " + listenerClassName);
        }
        if ((listener = InstanceFactory.newInstance(this.pluginClassLoader, listenerClassName)) instanceof HttpSessionActivationListener) {
            if (this._httpSessionActivationListeners == null) {
                this._httpSessionActivationListeners = new CopyOnWriteArrayList<HttpSessionActivationListener>();
            }
            this._httpSessionActivationListeners.add((HttpSessionActivationListener)listener);
        }
        if (listener instanceof HttpSessionAttributeListener) {
            if (this._httpSessionAttributeListeners == null) {
                this._httpSessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
            }
            this._httpSessionAttributeListeners.add((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionBindingListener) {
            if (this._httpSessionBindingListeners == null) {
                this._httpSessionBindingListeners = new CopyOnWriteArrayList<HttpSessionBindingListener>();
            }
            this._httpSessionBindingListeners.add((HttpSessionBindingListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            if (this._httpSessionListeners == null) {
                this._httpSessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
            }
            this._httpSessionListeners.add((HttpSessionListener)listener);
        }
        if (listener instanceof ServletContextListener) {
            if (this._servletContextListeners == null) {
                this._servletContextListeners = new CopyOnWriteArrayList<ServletContextListener>();
            }
            ServletContextListener servletContextListener = (ServletContextListener)listener;
            this._servletContextListeners.add(servletContextListener);
            ServletContextEvent servletContextEvent = new ServletContextEvent(this.servletContext);
            servletContextListener.contextInitialized(servletContextEvent);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            if (this._servletRequestAttributeListeners == null) {
                this._servletRequestAttributeListeners = new CopyOnWriteArrayList<ServletRequestAttributeListener>();
            }
            this._servletRequestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof ServletRequestListener) {
            if (this._servletRequestListeners == null) {
                this._servletRequestListeners = new CopyOnWriteArrayList<ServletRequestListener>();
            }
            this._servletRequestListeners.add((ServletRequestListener)listener);
        }
    }
}

