/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.persistence.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.ModelListenerRegistrationUtil;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class BasePersistenceImpl<T extends BaseModel<T>>
implements BasePersistence<T>,
SessionFactory {
    public static final String COUNT_COLUMN_NAME = "COUNT_VALUE";
    protected static final String CAST_CLOB_TEXT_OPEN = "CAST_CLOB_TEXT(";
    protected static final Object[] FINDER_ARGS_EMPTY = new Object[0];
    @Deprecated
    protected static final Comparator<String> NULL_SAFE_STRING_COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());
    protected static final String ORDER_BY_ASC = " ASC";
    protected static final String ORDER_BY_ASC_HAS_NEXT = " ASC, ";
    protected static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String ORDER_BY_DESC = " DESC";
    protected static final String ORDER_BY_DESC_HAS_NEXT = " DESC, ";
    protected static final String WHERE_AND = " AND ";
    protected static final String WHERE_GREATER_THAN = " >= ? ";
    protected static final String WHERE_GREATER_THAN_HAS_NEXT = " >= ? AND ";
    protected static final String WHERE_LESSER_THAN = " <= ? ";
    protected static final String WHERE_LESSER_THAN_HAS_NEXT = " <= ? AND ";
    protected static final String WHERE_OR = " OR ";
    protected static final NullModel nullModel = new NullModel();
    protected int databaseInMaxParameters;
    protected Map<String, String> dbColumnNames;
    protected boolean entityCacheEnabled;
    protected boolean finderCacheEnabled;
    private static final Log _log = LogFactoryUtil.getLog(BasePersistenceImpl.class);
    private int _databaseOrderByMaxColumns;
    private DataSource _dataSource;
    private DB _db;
    private Map<String, String> _dbColumnNames = Collections.emptyMap();
    private Dialect _dialect;
    private Class<T> _modelClass;
    private Class<? extends T> _modelImplClass;
    private ModelPKType _modelPKType = ModelPKType.COMPOUND;
    private SessionFactory _sessionFactory;

    public void cacheResult(T model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void clearCache(List<T> model) {
    }

    @Override
    public void clearCache(T model) {
    }

    @Override
    public void closeSession(Session session) {
        this._sessionFactory.closeSession(session);
    }

    @Override
    public long countWithDynamicQuery(DynamicQuery dynamicQuery) {
        return this.countWithDynamicQuery(dynamicQuery, ProjectionFactoryUtil.rowCount());
    }

    @Override
    public long countWithDynamicQuery(DynamicQuery dynamicQuery, Projection projection) {
        if (projection == null) {
            projection = ProjectionFactoryUtil.rowCount();
        }
        dynamicQuery.setProjection(projection);
        List results = this.findWithDynamicQuery(dynamicQuery);
        if (results.isEmpty()) {
            return 0L;
        }
        Long firstResult = (Long)results.get(0);
        return firstResult;
    }

    @Override
    public T fetchByPrimaryKey(Serializable primaryKey) {
        EntityCache entityCache = this.getEntityCache();
        Serializable serializable = entityCache.getResult(this.entityCacheEnabled, this._modelImplClass, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        BaseModel model = (BaseModel)serializable;
        if (model == null) {
            Session session = null;
            try {
                session = this.openSession();
                model = (BaseModel)session.get(this._modelImplClass, primaryKey);
                if (model == null) {
                    entityCache.putResult(this.entityCacheEnabled, this._modelImplClass, primaryKey, nullModel);
                } else {
                    this.cacheResult(model);
                }
            }
            catch (Exception e) {
                entityCache.removeResult(this.entityCacheEnabled, this._modelImplClass, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return (T)model;
    }

    @Override
    public Map<Serializable, T> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            T model = this.fetchByPrimaryKey(primaryKey);
            if (model == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(primaryKey, model);
        }
        HashMap<Serializable, Object> map = new HashMap<Serializable, Object>();
        if (this._modelPKType == ModelPKType.COMPOUND) {
            for (Serializable primaryKey : primaryKeys) {
                T model = this.fetchByPrimaryKey(primaryKey);
                if (model == null) continue;
                map.put(primaryKey, model);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        EntityCache entityCache = this.getEntityCache();
        for (Serializable primaryKey : primaryKeys) {
            Serializable serializable = entityCache.getResult(this.entityCacheEnabled, this._modelImplClass, primaryKey);
            if (serializable == nullModel) continue;
            if (serializable == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, (BaseModel)serializable);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(2 * uncachedPrimaryKeys.size() + 4);
        query.append(this.getSelectSQL());
        query.append(" WHERE ");
        query.append(this.getPKDBName());
        query.append(" IN (");
        if (this._modelPKType == ModelPKType.STRING) {
            for (int i = 0; i < uncachedPrimaryKeys.size(); ++i) {
                query.append("?");
                query.append(",");
            }
        } else {
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                query.append((Long)primaryKey);
                query.append(",");
            }
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            if (this._modelPKType == ModelPKType.STRING) {
                QueryPos qPos = QueryPos.getInstance(q);
                for (Serializable primaryKey : uncachedPrimaryKeys) {
                    qPos.add(primaryKey);
                }
            }
            for (BaseModel model : q.list()) {
                map.put(model.getPrimaryKeyObj(), model);
                this.cacheResult(model);
                uncachedPrimaryKeys.remove(model.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                entityCache.putResult(this.entityCacheEnabled, this._modelImplClass, primaryKey, nullModel);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    @Override
    public T findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> List<V> findWithDynamicQuery(DynamicQuery dynamicQuery) {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public <V> List<V> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public <V> List<V> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<V> orderByComparator) {
        OrderFactoryUtil.addOrderByComparator(dynamicQuery, orderByComparator);
        return this.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public void flush() {
        try {
            Session session = this._sessionFactory.getCurrentSession();
            if (session != null) {
                session.flush();
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public Set<String> getBadColumnNames() {
        return Collections.emptySet();
    }

    public Set<String> getCompoundPKColumnNames() {
        return Collections.emptySet();
    }

    @Override
    public Session getCurrentSession() throws ORMException {
        return this._sessionFactory.getCurrentSession();
    }

    @Override
    public DataSource getDataSource() {
        return this._dataSource;
    }

    public DB getDB() {
        return this._db;
    }

    @Override
    public Dialect getDialect() {
        return this._dialect;
    }

    @Override
    public ModelListener<T>[] getListeners() {
        return ModelListenerRegistrationUtil.getModelListeners(this.getModelClass());
    }

    @Override
    public Class<T> getModelClass() {
        return this._modelClass;
    }

    @Override
    public Session openNewSession(Connection connection) throws ORMException {
        return this._sessionFactory.openNewSession(connection);
    }

    @Override
    public Session openSession() throws ORMException {
        return this._sessionFactory.openSession();
    }

    @Override
    public SystemException processException(Exception e) {
        if (!(e instanceof ORMException)) {
            _log.error("Caught unexpected exception", e);
        } else if (_log.isDebugEnabled()) {
            _log.debug(e, e);
        }
        return new SystemException(e);
    }

    @Override
    public void registerListener(ModelListener<T> listener) {
        ModelListenerRegistrationUtil.register(listener);
    }

    @Override
    public T remove(Serializable primaryKey) throws NoSuchModelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(T model) {
        ModelListener<T>[] listeners;
        while (model instanceof ModelWrapper) {
            ModelWrapper modelWrapper = (ModelWrapper)model;
            model = (BaseModel)modelWrapper.getWrappedModel();
        }
        for (ModelListener<T> listener : listeners = this.getListeners()) {
            listener.onBeforeRemove(model);
        }
        model = this.removeImpl(model);
        for (ModelListener<T> listener : listeners) {
            listener.onAfterRemove(model);
        }
        return model;
    }

    public void setConfiguration(Configuration configuration) {
        String modelClassName = this._modelClass.getName();
        this.entityCacheEnabled = GetterUtil.getBoolean(configuration.get("value.object.entity.cache.enabled.".concat(modelClassName)), true);
        this.finderCacheEnabled = GetterUtil.getBoolean(configuration.get("value.object.finder.cache.enabled.".concat(modelClassName)), true);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
        this._dialect = this._sessionFactory.getDialect();
        this._db = DBManagerUtil.getDB(this._dialect, this.getDataSource());
        DBType dbType = this._db.getDBType();
        this._databaseOrderByMaxColumns = GetterUtil.getInteger(PropsUtil.get("database.order.by.max.columns", new Filter(dbType.getName())));
        this.databaseInMaxParameters = GetterUtil.getInteger(PropsUtil.get("database.in.max.parameters", new Filter(dbType.getName())));
    }

    @Override
    public void unregisterListener(ModelListener<T> listener) {
        ModelListenerRegistrationUtil.unregister(listener);
    }

    @Override
    public T update(T model) {
        ModelListener<T>[] listeners;
        while (model instanceof ModelWrapper) {
            ModelWrapper modelWrapper = (ModelWrapper)model;
            model = (BaseModel)modelWrapper.getWrappedModel();
        }
        boolean isNew = model.isNew();
        for (ModelListener<T> listener : listeners = this.getListeners()) {
            if (isNew) {
                listener.onBeforeCreate(model);
                continue;
            }
            listener.onBeforeUpdate(model);
        }
        model = this.updateImpl(model);
        for (ModelListener<T> listener : listeners) {
            if (isNew) {
                listener.onAfterCreate(model);
                continue;
            }
            listener.onAfterUpdate(model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T update(T model, ServiceContext serviceContext) {
        try {
            ServiceContextThreadLocal.pushServiceContext(serviceContext);
            T t = this.update(model);
            return t;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    protected static String removeConjunction(String sql) {
        int pos = sql.indexOf(WHERE_AND);
        if (pos != -1) {
            sql = sql.substring(0, pos);
        }
        return sql;
    }

    protected void appendOrderByComparator(StringBundler sb, String entityAlias, OrderByComparator<T> orderByComparator) {
        this.appendOrderByComparator(sb, entityAlias, orderByComparator, false);
    }

    protected void appendOrderByComparator(StringBundler sb, String entityAlias, OrderByComparator<T> orderByComparator, boolean sqlQuery) {
        sb.append(ORDER_BY_CLAUSE);
        String[] orderByFields = orderByComparator.getOrderByFields();
        int length = orderByFields.length;
        if (this._databaseOrderByMaxColumns > 0 && this._databaseOrderByMaxColumns < length) {
            length = this._databaseOrderByMaxColumns;
        }
        for (int i = 0; i < length; ++i) {
            sb.append(this.getColumnName(entityAlias, orderByFields[i], sqlQuery));
            if (i + 1 < length) {
                if (orderByComparator.isAscending(orderByFields[i])) {
                    sb.append(ORDER_BY_ASC_HAS_NEXT);
                    continue;
                }
                sb.append(ORDER_BY_DESC_HAS_NEXT);
                continue;
            }
            if (orderByComparator.isAscending(orderByFields[i])) {
                sb.append(ORDER_BY_ASC);
                continue;
            }
            sb.append(ORDER_BY_DESC);
        }
    }

    @Deprecated
    protected void appendOrderByComparator(com.liferay.portal.kernel.util.StringBundler sb, String entityAlias, OrderByComparator<T> orderByComparator) {
        this.appendOrderByComparator(sb, entityAlias, orderByComparator, false);
    }

    @Deprecated
    protected void appendOrderByComparator(com.liferay.portal.kernel.util.StringBundler sb, String entityAlias, OrderByComparator<T> orderByComparator, boolean sqlQuery) {
        StringBundler petraSB = new StringBundler(sb.getStrings());
        int index = sb.index();
        petraSB.setIndex(index);
        this.appendOrderByComparator(petraSB, entityAlias, orderByComparator, sqlQuery);
        for (int i = index; i < petraSB.index(); ++i) {
            sb.append(petraSB.stringAt(i));
        }
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    protected String getColumnName(String entityAlias, String fieldName, boolean sqlQuery) {
        String columnName = this._dbColumnNames.getOrDefault(fieldName, fieldName);
        if (sqlQuery) {
            fieldName = columnName;
        } else {
            Set<String> compoundPKColumnNames = this.getCompoundPKColumnNames();
            if (compoundPKColumnNames.contains(fieldName)) {
                fieldName = "id.".concat(fieldName);
            }
        }
        fieldName = entityAlias.concat(fieldName);
        Map<String, Integer> tableColumnsMap = this.getTableColumnsMap();
        Integer type = tableColumnsMap.get(columnName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown column name " + columnName);
        }
        if (type == 2005) {
            fieldName = CAST_CLOB_TEXT_OPEN.concat(fieldName).concat(")");
        }
        return fieldName;
    }

    protected EntityCache getEntityCache() {
        throw new UnsupportedOperationException();
    }

    protected String getPKDBName() {
        throw new UnsupportedOperationException();
    }

    protected String getSelectSQL() {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        throw new UnsupportedOperationException();
    }

    protected T removeImpl(T model) {
        throw new UnsupportedOperationException();
    }

    protected void setDBColumnNames(Map<String, String> dbColumnNames) {
        this._dbColumnNames = dbColumnNames;
    }

    protected void setEntityCacheEnabled(boolean entityCacheEnabled) {
        this.entityCacheEnabled = entityCacheEnabled;
    }

    protected void setModelClass(Class<T> modelClass) {
        this._modelClass = modelClass;
    }

    protected void setModelImplClass(Class<? extends T> modelImplClass) {
        this._modelImplClass = modelImplClass;
    }

    protected void setModelPKClass(Class<? extends Serializable> clazz) {
        if (clazz.isPrimitive()) {
            this._modelPKType = ModelPKType.NUMBER;
        } else if (String.class.isAssignableFrom(clazz)) {
            this._modelPKType = ModelPKType.STRING;
        }
    }

    protected T updateImpl(T model) {
        throw new UnsupportedOperationException();
    }

    private static enum ModelPKType {
        COMPOUND,
        NUMBER,
        STRING;

    }

    private static class NullModel
    implements BaseModel<NullModel>,
    CacheModel<NullModel>,
    MVCCModel {
        private NullModel() {
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public int compareTo(NullModel nullModel) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpandoBridge getExpandoBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getModelAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getModelClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModelClassName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getMvccVersion() {
            return -1L;
        }

        @Override
        public Serializable getPrimaryKeyObj() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCachedModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEntityCacheEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEscapedModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isFinderCacheEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNew() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetOriginalValues() {
        }

        @Override
        public void setCachedModel(boolean cachedModel) {
        }

        @Override
        public void setExpandoBridgeAttributes(BaseModel<?> baseModel) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setModelAttributes(Map<String, Object> attributes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMvccVersion(long mvccVersion) {
        }

        @Override
        public void setNew(boolean n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrimaryKeyObj(Serializable primaryKeyObj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheModel<NullModel> toCacheModel() {
            return nullModel;
        }

        @Override
        public NullModel toEntityModel() {
            return nullModel;
        }

        @Override
        public NullModel toEscapedModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NullModel toUnescapedModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toXmlString() {
            throw new UnsupportedOperationException();
        }
    }
}

