/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.internal.security.permission.resource.DefaultModelResourcePermission;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.definition.ModelResourcePermissionDefinition;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;

public class ModelResourcePermissionFactory {
    public static <T extends GroupedModel> ModelResourcePermission<T> create(Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, ModelResourcePermissionConfigurator<T> modelResourcePermissionConfigurator) {
        return ModelResourcePermissionFactory.create(modelClass, primKeyToLongFunction, getModelUnsafeFunction, portletResourcePermission, modelResourcePermissionConfigurator, UnaryOperator.identity());
    }

    public static <T extends GroupedModel> ModelResourcePermission<T> create(Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, ModelResourcePermissionConfigurator<T> modelResourcePermissionConfigurator, UnaryOperator<String> actionIdMapper) {
        ArrayList modelResourcePermissionLogics = new ArrayList();
        DefaultModelResourcePermissionDefinition modelResourcePermissionDefinition = new DefaultModelResourcePermissionDefinition(modelClass, primKeyToLongFunction, getModelUnsafeFunction, portletResourcePermission, actionIdMapper);
        DefaultModelResourcePermission modelResourcePermission = new DefaultModelResourcePermission(modelResourcePermissionDefinition, modelResourcePermissionLogics);
        modelResourcePermissionConfigurator.configureModelResourcePermissionLogics(modelResourcePermission, modelResourcePermissionLogics::add);
        return modelResourcePermission;
    }

    public static <T extends ClassedModel> ModelResourcePermission<T> getInstance(Class<? extends BaseService> declaringServiceClass, String fieldName, Class<T> modelClass) {
        return ServiceProxyFactory.newServiceTrackedInstance(ModelResourcePermission.class, declaringServiceClass, fieldName, "(model.class.name=" + modelClass.getName() + ")", true);
    }

    private static class DefaultModelResourcePermissionDefinition<T extends GroupedModel>
    implements ModelResourcePermissionDefinition<T> {
        private final UnaryOperator<String> _actionIdMapper;
        private final UnsafeFunction<Long, T, ? extends PortalException> _getModelUnsafeFunction;
        private final Class<T> _modelClass;
        private final PortletResourcePermission _portletResourcePermission;
        private final ToLongFunction<T> _primKeyToLongFunction;

        @Override
        public T getModel(long primaryKey) throws PortalException {
            return (T)((GroupedModel)this._getModelUnsafeFunction.apply(primaryKey));
        }

        @Override
        public Class<T> getModelClass() {
            return this._modelClass;
        }

        @Override
        public PortletResourcePermission getPortletResourcePermission() {
            return this._portletResourcePermission;
        }

        @Override
        public long getPrimaryKey(T t) {
            return this._primKeyToLongFunction.applyAsLong(t);
        }

        @Override
        public String mapActionId(String actionId) {
            return (String)this._actionIdMapper.apply(actionId);
        }

        @Override
        public void registerModelResourcePermissionLogics(ModelResourcePermission<T> modelResourcePermission, Consumer<ModelResourcePermissionLogic<T>> logicConsumer) {
        }

        private DefaultModelResourcePermissionDefinition(Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, UnaryOperator<String> actionIdMapper) {
            this._modelClass = Objects.requireNonNull(modelClass);
            this._primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
            this._getModelUnsafeFunction = Objects.requireNonNull(getModelUnsafeFunction);
            this._portletResourcePermission = portletResourcePermission;
            this._actionIdMapper = Objects.requireNonNull(actionIdMapper);
        }
    }

    @FunctionalInterface
    public static interface ModelResourcePermissionConfigurator<T extends GroupedModel> {
        public void configureModelResourcePermissionLogics(ModelResourcePermission<T> var1, Consumer<ModelResourcePermissionLogic<T>> var2);
    }
}

