/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManager;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpAuthManagerUtil {
    private static final HttpAuthManagerUtil _instance = new HttpAuthManagerUtil();
    private final ServiceTracker<?, HttpAuthManager> _serviceTracker;

    public static void generateChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        HttpAuthManagerUtil._getHttpAuthManager().generateChallenge(httpServletRequest, httpServletResponse, httpAuthorizationHeader);
    }

    public static long getBasicUserId(HttpServletRequest httpServletRequest) throws PortalException {
        return HttpAuthManagerUtil._getHttpAuthManager().getBasicUserId(httpServletRequest);
    }

    public static long getDigestUserId(HttpServletRequest httpServletRequest) throws PortalException {
        return HttpAuthManagerUtil._getHttpAuthManager().getDigestUserId(httpServletRequest);
    }

    public static long getUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        return HttpAuthManagerUtil._getHttpAuthManager().getUserId(httpServletRequest, httpAuthorizationHeader);
    }

    public static HttpAuthorizationHeader parse(HttpServletRequest httpServletRequest) {
        return HttpAuthManagerUtil._getHttpAuthManager().parse(httpServletRequest);
    }

    private static HttpAuthManager _getHttpAuthManager() {
        return HttpAuthManagerUtil._instance._serviceTracker.getService();
    }

    private HttpAuthManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(HttpAuthManager.class);
        this._serviceTracker.open();
    }
}

