/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final ThreadLocal<Long> _companyId = new CentralizedThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final ThreadLocal<Boolean> _deleteInProcess = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._deleteInProcess", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static boolean isDeleteInProcess() {
        return _deleteInProcess.get();
    }

    public static void setCompanyId(Long companyId) {
        if (companyId.equals(_companyId.get())) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            _companyId.set(companyId);
            try {
                Company company = CompanyLocalServiceUtil.getCompany(companyId);
                LocaleThreadLocal.setDefaultLocale(company.getLocale());
                TimeZoneThreadLocal.setDefaultTimeZone(company.getTimeZone());
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        } else {
            _companyId.set(0L);
            LocaleThreadLocal.setDefaultLocale(null);
            TimeZoneThreadLocal.setDefaultTimeZone(null);
        }
    }

    public static void setDeleteInProcess(boolean deleteInProcess) {
        _deleteInProcess.set(deleteInProcess);
    }
}

