/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelist;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseAuthTokenWhitelist
implements AuthTokenWhitelist {
    protected final StringServiceRegistrationMap<Object> serviceRegistrations = new StringServiceRegistrationMapImpl<Object>();
    protected final List<ServiceTracker<Object, Object>> serviceTrackers = new ArrayList<ServiceTracker<Object, Object>>();

    @Override
    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        return false;
    }

    @Override
    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return false;
    }

    @Override
    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return false;
    }

    @Override
    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        return false;
    }

    @Override
    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        return false;
    }

    @Override
    public boolean isValidSharedSecret(String sharedSecret) {
        return false;
    }

    protected void destroy() {
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        for (ServiceTracker serviceTracker : this.serviceTrackers) {
            serviceTracker.close();
        }
    }

    protected void registerPortalProperty(String key) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Object[] values = PropsUtil.getArray(key);
        properties.put(key, values);
        ServiceRegistration<Object> serviceRegistration = registry.registerService(Object.class, new Object(), properties);
        this.serviceRegistrations.put(StringUtil.merge(values), serviceRegistration);
    }

    protected ServiceTracker<Object, Object> trackWhitelistServices(String whitelistName, Set<String> whiteList) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceTracker<Object, Object> serviceTracker = registry.trackServices(registry.getFilter("(" + whitelistName + "=*)"), new TokenWhitelistTrackerCustomizer(whitelistName, whiteList));
        serviceTracker.open();
        this.serviceTrackers.add(serviceTracker);
        return serviceTracker;
    }

    private static class TokenWhitelistTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final Set<String> _whitelist;
        private final String _whitelistName;

        public TokenWhitelistTrackerCustomizer(String whitelistName, Set<String> whitelist) {
            this._whitelistName = whitelistName;
            this._whitelist = whitelist;
        }

        @Override
        public Object addingService(ServiceReference<Object> serviceReference) {
            List<String> authTokenIgnoreActions = StringPlus.asList(serviceReference.getProperty(this._whitelistName));
            this._whitelist.addAll(authTokenIgnoreActions);
            return authTokenIgnoreActions;
        }

        @Override
        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
            this.removedService(serviceReference, object);
            this.addingService(serviceReference);
        }

        @Override
        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            Collection authTokenIgnoreActions = (Collection)object;
            this._whitelist.removeAll(authTokenIgnoreActions);
        }
    }
}

