/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.generic;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MoreLikeThisQuery
extends BaseQueryImpl {
    private String _analyzer;
    private final long _companyId;
    private final Set<String> _documentUIDs = new HashSet<String>();
    private final List<String> _fields = new ArrayList<String>();
    private Boolean _includeInput;
    private String _likeText;
    private Integer _maxDocFrequency;
    private Integer _maxQueryTerms;
    private Integer _maxWordLength;
    private Integer _minDocFrequency;
    private String _minShouldMatch;
    private Integer _minTermFrequency;
    private Integer _minWordLength;
    private final Set<String> _stopWords = new HashSet<String>();
    private Float _termBoost;
    private String _type;

    public MoreLikeThisQuery(long companyId) {
        this._companyId = companyId;
    }

    @Override
    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return queryVisitor.visitQuery(this);
    }

    public void addDocumentUID(String documentUID) {
        this._documentUIDs.add(documentUID);
    }

    public void addDocumentUIDs(Collection<String> documentUIDs) {
        this._documentUIDs.addAll(documentUIDs);
    }

    public void addDocumentUIDs(String ... documentUIDs) {
        Collections.addAll(this._documentUIDs, documentUIDs);
    }

    public void addField(String field) {
        this._fields.add(field);
    }

    public void addFields(Collection<String> fields) {
        this._fields.addAll(fields);
    }

    public void addFields(String ... fields) {
        Collections.addAll(this._fields, fields);
    }

    public void addStopWord(String stopWord) {
        this._stopWords.add(stopWord);
    }

    public void addStopWords(Collection<String> stopWords) {
        this._stopWords.addAll(stopWords);
    }

    public void addStopWords(String ... stopWords) {
        Collections.addAll(this._stopWords, stopWords);
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Set<String> getDocumentUIDs() {
        return Collections.unmodifiableSet(this._documentUIDs);
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(this._fields);
    }

    public String getLikeText() {
        return this._likeText;
    }

    public Integer getMaxDocFrequency() {
        return this._maxDocFrequency;
    }

    public Integer getMaxQueryTerms() {
        return this._maxQueryTerms;
    }

    public Integer getMaxWordLength() {
        return this._maxWordLength;
    }

    public Integer getMinDocFrequency() {
        return this._minDocFrequency;
    }

    public String getMinShouldMatch() {
        return this._minShouldMatch;
    }

    public Integer getMinTermFrequency() {
        return this._minTermFrequency;
    }

    public Integer getMinWordLength() {
        return this._minWordLength;
    }

    public Set<String> getStopWords() {
        return Collections.unmodifiableSet(this._stopWords);
    }

    public Float getTermBoost() {
        return this._termBoost;
    }

    public String getType() {
        return this._type;
    }

    public boolean isDocumentUIDsEmpty() {
        return this._documentUIDs.isEmpty();
    }

    public boolean isFieldsEmpty() {
        return this._fields.isEmpty();
    }

    public Boolean isIncludeInput() {
        return this._includeInput;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setIncludeInput(Boolean includeInput) {
        this._includeInput = includeInput;
    }

    public void setLikeText(String likeText) {
        this._likeText = likeText;
    }

    public void setMaxDocFrequency(Integer maxDocFrequency) {
        this._maxDocFrequency = maxDocFrequency;
    }

    public void setMaxQueryTerms(Integer maxQueryTerms) {
        this._maxQueryTerms = maxQueryTerms;
    }

    public void setMaxWordLength(Integer maxWordLength) {
        this._maxWordLength = maxWordLength;
    }

    public void setMinDocFrequency(Integer minDocFrequency) {
        this._minDocFrequency = minDocFrequency;
    }

    public void setMinShouldMatch(String minShouldMatch) {
        this._minShouldMatch = minShouldMatch;
    }

    public void setMinTermFrequency(Integer minTermFrequency) {
        this._minTermFrequency = minTermFrequency;
    }

    public void setMinWordLength(Integer minWordLength) {
        this._minWordLength = minWordLength;
    }

    public void setTermBoost(Float termBoost) {
        this._termBoost = termBoost;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String toString() {
        StringBundler sb = new StringBundler(35);
        sb.append("{analyzer=");
        sb.append(this._analyzer);
        sb.append(", className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", companyId=");
        sb.append(this._companyId);
        sb.append(", documentUIDs=");
        sb.append(this._documentUIDs);
        sb.append(", fields=");
        sb.append(this._fields);
        sb.append(", includeInput=");
        sb.append(this._includeInput);
        sb.append(", likeText=");
        sb.append(this._likeText);
        sb.append(", maxDocFrequency=");
        sb.append(this._maxDocFrequency);
        sb.append(", maxQueryTerms=");
        sb.append(this._maxQueryTerms);
        sb.append(", maxWordLength=");
        sb.append(this._maxWordLength);
        sb.append(", minDocFrequency=");
        sb.append(this._minDocFrequency);
        sb.append(", minShouldMatch=");
        sb.append(this._minShouldMatch);
        sb.append(", minTermFrequency=");
        sb.append(this._minTermFrequency);
        sb.append(", minWordLength=");
        sb.append(this._minWordLength);
        sb.append(", stopWords=");
        sb.append(this._stopWords);
        sb.append(", termBoost=");
        sb.append(this._termBoost);
        sb.append(", type=");
        sb.append(this._type);
        sb.append("}");
        return sb.toString();
    }
}

