/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenSearchRegistryUtil {
    private static final OpenSearchRegistryUtil _instance = new OpenSearchRegistryUtil();
    private final Map<String, OpenSearch> _openSearchInstances = new ConcurrentHashMap<String, OpenSearch>();
    private final ServiceTracker<OpenSearch, OpenSearch> _serviceTracker;

    public static OpenSearch getOpenSearch(Class<?> clazz) {
        return OpenSearchRegistryUtil._instance._openSearchInstances.get(clazz.getName());
    }

    public static OpenSearch getOpenSearch(String className) {
        return OpenSearchRegistryUtil._instance._openSearchInstances.get(className);
    }

    public static List<OpenSearch> getOpenSearchInstances() {
        ArrayList<OpenSearch> openSearchInstances = new ArrayList<OpenSearch>(OpenSearchRegistryUtil._instance._openSearchInstances.values());
        return Collections.unmodifiableList(openSearchInstances);
    }

    private OpenSearchRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(OpenSearch.class, new OpenSearchServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private class OpenSearchServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<OpenSearch, OpenSearch> {
        private OpenSearchServiceTrackerCustomizer() {
        }

        @Override
        public OpenSearch addingService(ServiceReference<OpenSearch> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            OpenSearch openSearch = registry.getService(serviceReference);
            OpenSearchRegistryUtil.this._openSearchInstances.put(openSearch.getClassName(), openSearch);
            return openSearch;
        }

        @Override
        public void modifiedService(ServiceReference<OpenSearch> serviceReference, OpenSearch openSearch) {
        }

        @Override
        public void removedService(ServiceReference<OpenSearch> serviceReference, OpenSearch openSearch) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            OpenSearchRegistryUtil.this._openSearchInstances.remove(openSearch.getClassName());
        }
    }
}

