/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HitsImpl
implements Hits {
    private static final Document[] _EMPTY_DOCUMENTS = new Document[0];
    private String _collatedSpellCheckResult;
    private Document[] _docs = _EMPTY_DOCUMENTS;
    private final Map<String, Hits> _groupedHits = new HashMap<String, Hits>();
    private int _length;
    private Query _query;
    private String[] _querySuggestions;
    private String[] _queryTerms;
    private float[] _scores = new float[0];
    private float _searchTime;
    private String[] _snippets = new String[0];
    private Map<String, List<String>> _spellCheckResults;
    private long _start;
    private final Map<String, StatsResults> _statsResults = new HashMap<String, StatsResults>();

    @Override
    public void addGroupedHits(String groupValue, Hits hits) {
        this._groupedHits.put(groupValue, hits);
    }

    @Override
    public void addStatsResults(StatsResults statsResults) {
        this._statsResults.put(statsResults.getField(), statsResults);
    }

    @Override
    public void copy(Hits hits) {
        this.setDocs(hits.getDocs());
        this.setLength(hits.getLength());
        this.setQuery(hits.getQuery());
        this.setQuerySuggestions(hits.getQuerySuggestions());
        this.setQueryTerms(hits.getQueryTerms());
        this.setScores(hits.getScores());
        this.setSearchTime(hits.getSearchTime());
        this.setSnippets(hits.getSnippets());
        this.setSpellCheckResults(hits.getSpellCheckResults());
        this.setStart(hits.getStart());
    }

    @Override
    public Document doc(int n) {
        return this._docs[n];
    }

    @Override
    @JSON
    public String getCollatedSpellCheckResult() {
        return this._collatedSpellCheckResult;
    }

    @Override
    @JSON
    public Document[] getDocs() {
        return this._docs;
    }

    @Override
    public Map<String, Hits> getGroupedHits() {
        return Collections.unmodifiableMap(this._groupedHits);
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    @JSON(include=false)
    public Query getQuery() {
        return this._query;
    }

    @Override
    @JSON
    public String[] getQuerySuggestions() {
        if (ArrayUtil.isEmpty(this._querySuggestions)) {
            return StringPool.EMPTY_ARRAY;
        }
        return this._querySuggestions;
    }

    @Override
    @JSON
    public String[] getQueryTerms() {
        return this._queryTerms;
    }

    @Override
    @JSON
    public float[] getScores() {
        return this._scores;
    }

    @Override
    public float getSearchTime() {
        return this._searchTime;
    }

    @Override
    @JSON
    public String[] getSnippets() {
        return this._snippets;
    }

    @Override
    public Map<String, List<String>> getSpellCheckResults() {
        return this._spellCheckResults;
    }

    @Override
    public long getStart() {
        return this._start;
    }

    @Override
    public Map<String, StatsResults> getStatsResults() {
        return Collections.unmodifiableMap(this._statsResults);
    }

    @Override
    public boolean hasGroupedHits() {
        return !this._groupedHits.isEmpty();
    }

    @Override
    public float score(int n) {
        return this._scores[n];
    }

    @Override
    public void setCollatedSpellCheckResult(String collatedSpellCheckResult) {
        this._collatedSpellCheckResult = collatedSpellCheckResult;
    }

    @Override
    public void setDocs(Document[] docs) {
        this._docs = docs;
    }

    @Override
    public void setLength(int length) {
        this._length = length;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public void setQuerySuggestions(String[] querySuggestions) {
        this._querySuggestions = querySuggestions;
    }

    @Override
    public void setQueryTerms(String[] queryTerms) {
        this._queryTerms = queryTerms;
    }

    @Override
    public void setScores(float[] scores) {
        this._scores = scores;
    }

    @Override
    public void setSearchTime(float time) {
        this._searchTime = time;
    }

    @Override
    public void setSnippets(String[] snippets) {
        this._snippets = snippets;
    }

    @Override
    public void setSpellCheckResults(Map<String, List<String>> spellCheckResults) {
        this._spellCheckResults = spellCheckResults;
    }

    @Override
    public void setStart(long start) {
        this._start = start;
    }

    @Override
    public String snippet(int n) {
        return this._snippets[n];
    }

    @Override
    public List<Document> toList() {
        return Arrays.asList(this._docs);
    }

    public String toString() {
        if (this._docs == null || this._docs.length == 0) {
            StringBundler sb = new StringBundler(5);
            sb.append("{docs={}, length=");
            sb.append(this._length);
            sb.append(", query=");
            sb.append(this._query);
            sb.append("]");
            return sb.toString();
        }
        StringBundler sb = new StringBundler(2 * this._docs.length + 4);
        sb.append("[");
        for (Document document : this._docs) {
            sb.append(document);
            sb.append(", ");
        }
        sb.setStringAt("}, length=", sb.index() - 1);
        sb.append(this._length);
        sb.append(", query=");
        sb.append(this._query);
        sb.append("]");
        return sb.toString();
    }
}

