/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.toolbar;

import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.locator.PortletToolbarContributorLocator;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class PortletToolbar {
    private static final List<PortletToolbarContributorLocator> _portletToolbarContributorLocators = new CopyOnWriteArrayList<PortletToolbarContributorLocator>();
    private final ServiceTracker<PortletToolbarContributorLocator, PortletToolbarContributorLocator> _serviceTracker;

    public PortletToolbar() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(PortletToolbarContributorLocator.class, new PortletToolbarServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public List<Menu> getPortletTitleMenus(String portletId, PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletRequest == null || portletResponse == null || Validator.isNull(portletId)) {
            return Collections.emptyList();
        }
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(portletRequest));
        String layoutMode = ParamUtil.getString(originalHttpServletRequest, "p_l_mode", "view");
        ArrayList<Menu> portletTitleMenus = new ArrayList<Menu>();
        for (PortletToolbarContributorLocator portletToolbarContributorLocator : _portletToolbarContributorLocators) {
            List<PortletToolbarContributor> portletToolbarContributors = portletToolbarContributorLocator.getPortletToolbarContributors(portletId, portletRequest);
            if (portletToolbarContributors == null) continue;
            for (PortletToolbarContributor portletToolbarContributor : portletToolbarContributors) {
                List<Menu> curPortletTitleMenus;
                if (Objects.equals(layoutMode, "edit") && !portletToolbarContributor.isShowInEditMode() || ListUtil.isEmpty(curPortletTitleMenus = portletToolbarContributor.getPortletTitleMenus(portletRequest, portletResponse))) continue;
                portletTitleMenus.addAll(curPortletTitleMenus);
            }
        }
        return portletTitleMenus;
    }

    private static class PortletToolbarServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortletToolbarContributorLocator, PortletToolbarContributorLocator> {
        private PortletToolbarServiceTrackerCustomizer() {
        }

        @Override
        public PortletToolbarContributorLocator addingService(ServiceReference<PortletToolbarContributorLocator> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortletToolbarContributorLocator portletToolbarContributorLocator = registry.getService(serviceReference);
            _portletToolbarContributorLocators.add(portletToolbarContributorLocator);
            return portletToolbarContributorLocator;
        }

        @Override
        public void modifiedService(ServiceReference<PortletToolbarContributorLocator> serviceReference, PortletToolbarContributorLocator portletToolbarContributorLocator) {
        }

        @Override
        public void removedService(ServiceReference<PortletToolbarContributorLocator> serviceReference, PortletToolbarContributorLocator portletToolbarContributorLocator) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _portletToolbarContributorLocators.remove(portletToolbarContributorLocator);
        }
    }
}

