/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletDisplayModel;
import com.liferay.portal.kernel.portlet.ThemeDisplayModel;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class PortletRequestModel
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(PortletRequestModel.class);
    private String _actionURL;
    private Map<String, Object> _applicationScopeSessionAttributes;
    private Map<String, Object> _attributes;
    private final String _authType;
    private final String _contentType;
    private final String _contextPath;
    private final String _lifecycle;
    private final Locale _locale;
    private Map<String, String[]> _parameters;
    private final PortletMode _portletMode;
    private final String _portletNamespace;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;
    private Map<String, Object> _portletScopeSessioAttributes;
    private final String _portletSessionId;
    private final String _remoteUser;
    private String _renderURL;
    private String _renderURLExclusive;
    private String _renderURLMaximized;
    private String _renderURLMinimized;
    private String _renderURLNormal;
    private String _renderURLPopUp;
    private String _resourceURL;
    private final String _scheme;
    private final boolean _secure;
    private final String _serverName;
    private final int _serverPort;
    private final ThemeDisplayModel _themeDisplayModel;
    private final WindowState _windowState;

    public PortletRequestModel(PortletRequest portletRequest, PortletResponse portletResponse) {
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._contentType = portletRequest.getResponseContentType();
        this._serverName = portletRequest.getServerName();
        this._serverPort = portletRequest.getServerPort();
        this._secure = portletRequest.isSecure();
        this._authType = portletRequest.getAuthType();
        this._remoteUser = portletRequest.getRemoteUser();
        this._contextPath = portletRequest.getContextPath();
        this._locale = portletRequest.getLocale();
        this._portletMode = portletRequest.getPortletMode();
        this._portletSessionId = portletRequest.getRequestedSessionId();
        this._scheme = portletRequest.getScheme();
        this._windowState = portletRequest.getWindowState();
        this._lifecycle = portletRequest instanceof ActionRequest ? "ACTION_PHASE" : (portletRequest instanceof RenderRequest ? "RENDER_PHASE" : (portletRequest instanceof ResourceRequest ? "RESOURCE_PHASE" : null));
        if (this._portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this._portletResponse;
            this._portletNamespace = mimeResponse.getNamespace();
        } else {
            this._portletNamespace = null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._themeDisplayModel = themeDisplay != null ? new ThemeDisplayModel(themeDisplay) : null;
    }

    public String getActionURL() {
        this._initURLs();
        return this._actionURL;
    }

    public Map<String, Object> getApplicationScopeSessionAttributes() {
        this._initPortletSessionAttributes();
        return this._applicationScopeSessionAttributes;
    }

    public Map<String, Object> getAttributes() {
        this._initAttributes();
        return this._attributes;
    }

    public String getAuthType() {
        return this._authType;
    }

    public String getContainerNamespace() {
        return this._contextPath;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Map<String, String[]> getParameters() {
        this._initParameters();
        return this._parameters;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getPortletNamespace() {
        return this._portletNamespace;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public PortletResponse getPortletResponse() {
        return this._portletResponse;
    }

    public Map<String, Object> getPortletScopeSessioAttributes() {
        this._initPortletSessionAttributes();
        return this._portletScopeSessioAttributes;
    }

    public String getPortletSessionId() {
        return this._portletSessionId;
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public String getRenderURL() {
        this._initURLs();
        return this._renderURL;
    }

    public String getRenderURLExclusive() {
        this._initURLs();
        return this._renderURLExclusive;
    }

    public String getRenderURLMaximized() {
        this._initURLs();
        return this._renderURLMaximized;
    }

    public String getRenderURLMinimized() {
        this._initURLs();
        return this._renderURLMinimized;
    }

    public String getRenderURLNormal() {
        this._initURLs();
        return this._renderURLNormal;
    }

    public String getRenderURLPopUp() {
        this._initURLs();
        return this._renderURLPopUp;
    }

    public String getResourceURL() {
        this._initURLs();
        return this._resourceURL;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public ThemeDisplayModel getThemeDisplayModel() {
        return this._themeDisplayModel;
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> portletRequestModelMap = new HashMap<String, Object>();
        portletRequestModelMap.put("auth-type", this._authType);
        portletRequestModelMap.put("container-namespace", this._contextPath);
        portletRequestModelMap.put("container-type", "portlet");
        portletRequestModelMap.put("content-type", this._contentType);
        portletRequestModelMap.put("context-path", this._contextPath);
        portletRequestModelMap.put("lifecycle", this._lifecycle);
        portletRequestModelMap.put("locale", this._locale);
        portletRequestModelMap.put("portlet-mode", this._portletMode);
        portletRequestModelMap.put("portlet-session-id", this._portletSessionId);
        portletRequestModelMap.put("remote-user", this._remoteUser);
        portletRequestModelMap.put("scheme", this._scheme);
        portletRequestModelMap.put("secure", this._secure);
        portletRequestModelMap.put("server-name", this._serverName);
        portletRequestModelMap.put("server-port", this._serverPort);
        portletRequestModelMap.put("window-state", this._windowState);
        if (this._portletNamespace != null) {
            portletRequestModelMap.put("portlet-namespace", this._portletNamespace);
            this._initURLs();
            if (this._actionURL != null) {
                portletRequestModelMap.put("action-url", "_actionURL");
            }
            if (this._renderURL != null) {
                portletRequestModelMap.put("render-url", this._renderURL);
                if (this._renderURLExclusive != null) {
                    portletRequestModelMap.put("render-url-exclusive", this._renderURLExclusive);
                }
                if (this._renderURLMaximized != null) {
                    portletRequestModelMap.put("render-url-maximized", this._renderURLMaximized);
                }
                if (this._renderURLMinimized != null) {
                    portletRequestModelMap.put("render-url-minimized", this._renderURLMinimized);
                }
                if (this._renderURLNormal != null) {
                    portletRequestModelMap.put("render-url-normal", this._renderURLNormal);
                }
                if (this._renderURLPopUp != null) {
                    portletRequestModelMap.put("render-url-pop-up", this._renderURLPopUp);
                }
            }
            portletRequestModelMap.put("resource-url", this._resourceURL);
        }
        if (this._themeDisplayModel != null) {
            HashMap<String, Object> themeDisplayModelMap = new HashMap<String, Object>();
            portletRequestModelMap.put("theme-display", themeDisplayModelMap);
            themeDisplayModelMap.put("cdn-host", this._themeDisplayModel.getCdnHost());
            themeDisplayModelMap.put("company-id", this._themeDisplayModel.getCompanyId());
            themeDisplayModelMap.put("do-as-user-id", this._themeDisplayModel.getDoAsUserId());
            themeDisplayModelMap.put("i18n-language-id", this._themeDisplayModel.getI18nLanguageId());
            themeDisplayModelMap.put("i18n-path", this._themeDisplayModel.getI18nPath());
            themeDisplayModelMap.put("language-id", this._themeDisplayModel.getLanguageId());
            themeDisplayModelMap.put("locale", this._themeDisplayModel.getLocale());
            themeDisplayModelMap.put("path-context", this._themeDisplayModel.getPathContext());
            themeDisplayModelMap.put("path-friendly-url-private-group", this._themeDisplayModel.getPathFriendlyURLPrivateGroup());
            themeDisplayModelMap.put("path-friendly-url-private-user", this._themeDisplayModel.getPathFriendlyURLPrivateUser());
            themeDisplayModelMap.put("path-friendly-url-public", this._themeDisplayModel.getPathFriendlyURLPublic());
            themeDisplayModelMap.put("path-image", this._themeDisplayModel.getPathImage());
            themeDisplayModelMap.put("path-main", this._themeDisplayModel.getPathMain());
            themeDisplayModelMap.put("path-theme-images", this._themeDisplayModel.getPathThemeImages());
            themeDisplayModelMap.put("plid", this._themeDisplayModel.getPlid());
            themeDisplayModelMap.put("portal-url", this._themeDisplayModel.getPortalURL());
            themeDisplayModelMap.put("real-user-id", this._themeDisplayModel.getRealUserId());
            themeDisplayModelMap.put("scope-group-id", this._themeDisplayModel.getScopeGroupId());
            themeDisplayModelMap.put("secure", this._themeDisplayModel.isSecure());
            themeDisplayModelMap.put("server-name", this._themeDisplayModel.getServerName());
            themeDisplayModelMap.put("server-port", this._themeDisplayModel.getServerPort());
            TimeZone timeZone = this._themeDisplayModel.getTimeZone();
            themeDisplayModelMap.put("time-zone", timeZone.getID());
            themeDisplayModelMap.put("url-portal", this._themeDisplayModel.getURLPortal());
            themeDisplayModelMap.put("user-id", this._themeDisplayModel.getUserId());
            PortletDisplayModel portletDisplayModel = this._themeDisplayModel.getPortletDisplayModel();
            if (portletDisplayModel != null) {
                HashMap<String, String> portletDisplayModelMap = new HashMap<String, String>();
                themeDisplayModelMap.put("portlet-display", portletDisplayModelMap);
                portletDisplayModelMap.put("id", portletDisplayModel.getId());
                portletDisplayModelMap.put("instance-id", portletDisplayModel.getInstanceId());
                portletDisplayModelMap.put("portlet-name", portletDisplayModel.getPortletName());
                portletDisplayModelMap.put("resource-pk", portletDisplayModel.getResourcePK());
                portletDisplayModelMap.put("root-portlet-id", portletDisplayModel.getRootPortletId());
                portletDisplayModelMap.put("title", portletDisplayModel.getTitle());
            }
        }
        portletRequestModelMap.put("parameters", this.getParameters());
        this._attributes = this.filterInvalidAttributes(this.getAttributes());
        portletRequestModelMap.put("attributes", this._attributes);
        HashMap<String, Map<String, Object>> portletSessionMap = new HashMap<String, Map<String, Object>>();
        portletRequestModelMap.put("portlet-session", portletSessionMap);
        this._portletScopeSessioAttributes = this.filterInvalidAttributes(this.getPortletScopeSessioAttributes());
        portletSessionMap.put("portlet-attributes", this._portletScopeSessioAttributes);
        this._applicationScopeSessionAttributes = this.filterInvalidAttributes(this.getApplicationScopeSessionAttributes());
        portletSessionMap.put("application-attributes", this._applicationScopeSessionAttributes);
        return portletRequestModelMap;
    }

    public String toXML() {
        Element requestElement = new Element("request");
        requestElement.addElement("container-type", "portlet");
        requestElement.addElement("container-namespace", this._contextPath);
        requestElement.addElement("content-type", this._contentType);
        requestElement.addElement("server-name", this._serverName);
        requestElement.addElement("server-port", this._serverPort);
        requestElement.addElement("secure", this._secure);
        requestElement.addElement("auth-type", this._authType);
        requestElement.addElement("remote-user", this._remoteUser);
        requestElement.addElement("context-path", this._contextPath);
        requestElement.addElement("locale", this._locale);
        requestElement.addElement("portlet-mode", this._portletMode);
        requestElement.addElement("portlet-session-id", this._portletSessionId);
        requestElement.addElement("scheme", this._scheme);
        requestElement.addElement("window-state", this._windowState);
        requestElement.addElement("lifecycle", this._lifecycle);
        if (this._portletNamespace != null) {
            requestElement.addElement("portlet-namespace", this._portletNamespace);
            this._initURLs();
            if (this._actionURL != null) {
                requestElement.addElement("action-url", this._actionURL);
            }
            if (this._renderURL != null) {
                requestElement.addElement("render-url", this._renderURL);
                if (this._renderURLExclusive != null) {
                    requestElement.addElement("render-url-exclusive", this._renderURLExclusive);
                }
                if (this._renderURLMaximized != null) {
                    requestElement.addElement("render-url-maximized", this._renderURLMaximized);
                }
                if (this._renderURLMinimized != null) {
                    requestElement.addElement("render-url-minimized", this._renderURLMinimized);
                }
                if (this._renderURLNormal != null) {
                    requestElement.addElement("render-url-normal", this._renderURLNormal);
                }
                if (this._renderURLPopUp != null) {
                    requestElement.addElement("render-url-pop-up", this._renderURLPopUp);
                }
            }
            requestElement.addElement("resource-url", this._resourceURL);
        }
        if (this._themeDisplayModel != null) {
            Element themeDisplayElement = requestElement.addElement("theme-display");
            themeDisplayElement.addElement("cdn-host", this._themeDisplayModel.getCdnHost());
            themeDisplayElement.addElement("company-id", this._themeDisplayModel.getCompanyId());
            themeDisplayElement.addElement("do-as-user-id", this._themeDisplayModel.getDoAsUserId());
            themeDisplayElement.addElement("i18n-language-id", this._themeDisplayModel.getI18nLanguageId());
            themeDisplayElement.addElement("i18n-path", this._themeDisplayModel.getI18nPath());
            themeDisplayElement.addElement("language-id", this._themeDisplayModel.getLanguageId());
            themeDisplayElement.addElement("locale", this._themeDisplayModel.getLocale());
            themeDisplayElement.addElement("path-context", this._themeDisplayModel.getPathContext());
            themeDisplayElement.addElement("path-friendly-url-private-group", this._themeDisplayModel.getPathFriendlyURLPrivateGroup());
            themeDisplayElement.addElement("path-friendly-url-private-user", this._themeDisplayModel.getPathFriendlyURLPrivateUser());
            themeDisplayElement.addElement("path-friendly-url-public", this._themeDisplayModel.getPathFriendlyURLPublic());
            themeDisplayElement.addElement("path-image", this._themeDisplayModel.getPathImage());
            themeDisplayElement.addElement("path-main", this._themeDisplayModel.getPathMain());
            themeDisplayElement.addElement("path-theme-images", this._themeDisplayModel.getPathThemeImages());
            themeDisplayElement.addElement("plid", this._themeDisplayModel.getPlid());
            themeDisplayElement.addElement("portal-url", this._themeDisplayModel.getPortalURL());
            themeDisplayElement.addElement("real-user-id", this._themeDisplayModel.getRealUserId());
            themeDisplayElement.addElement("scope-group-id", this._themeDisplayModel.getScopeGroupId());
            themeDisplayElement.addElement("secure", this._themeDisplayModel.isSecure());
            themeDisplayElement.addElement("server-name", this._themeDisplayModel.getServerName());
            themeDisplayElement.addElement("server-port", this._themeDisplayModel.getServerPort());
            TimeZone timeZone = this._themeDisplayModel.getTimeZone();
            themeDisplayElement.addElement("time-zone", timeZone.getID());
            themeDisplayElement.addElement("url-portal", this._themeDisplayModel.getURLPortal());
            themeDisplayElement.addElement("user-id", this._themeDisplayModel.getUserId());
            PortletDisplayModel portletDisplayModel = this._themeDisplayModel.getPortletDisplayModel();
            if (portletDisplayModel != null) {
                Element portletDisplayElement = themeDisplayElement.addElement("portlet-display");
                portletDisplayElement.addElement("id", portletDisplayModel.getId());
                portletDisplayElement.addElement("instance-id", portletDisplayModel.getInstanceId());
                portletDisplayElement.addElement("portlet-name", portletDisplayModel.getPortletName());
                portletDisplayElement.addElement("resource-pk", portletDisplayModel.getResourcePK());
                portletDisplayElement.addElement("root-portlet-id", portletDisplayModel.getRootPortletId());
                portletDisplayElement.addElement("title", portletDisplayModel.getTitle());
            }
        }
        Element parametersElement = requestElement.addElement("parameters");
        Map<String, String[]> parameters = this.getParameters();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            Element parameterElement = parametersElement.addElement("parameter");
            parameterElement.addElement("name", entry.getKey());
            for (String value : entry.getValue()) {
                parameterElement.addElement("value", value);
            }
        }
        Element attributesElement = requestElement.addElement("attributes");
        Map<String, Object> attributes = this.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (!PortletRequestModel._isValidAttributeName(name) || !PortletRequestModel._isValidAttributeValue(value = entry.getValue())) continue;
            Element attributeElement = attributesElement.addElement("attribute");
            attributeElement.addElement("name", name);
            attributeElement.addElement("value", value);
        }
        Element portletSessionElement = requestElement.addElement("portlet-session");
        attributesElement = portletSessionElement.addElement("portlet-attributes");
        Map<String, Object> map = this.getPortletScopeSessioAttributes();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value;
            String name = entry.getKey();
            if (!PortletRequestModel._isValidAttributeName(name) || !PortletRequestModel._isValidAttributeValue(value = entry.getValue())) continue;
            Element attributeElement = attributesElement.addElement("attribute");
            attributeElement.addElement("name", name);
            attributeElement.addElement("value", value);
        }
        attributesElement = portletSessionElement.addElement("application-attributes");
        Map<String, Object> applicationScopeSessionAttributes = this.getApplicationScopeSessionAttributes();
        for (Map.Entry<String, Object> entry : applicationScopeSessionAttributes.entrySet()) {
            Object value;
            String name = entry.getKey();
            if (!PortletRequestModel._isValidAttributeName(name) || !PortletRequestModel._isValidAttributeValue(value = entry.getValue())) continue;
            Element attributeElement = attributesElement.addElement("attribute");
            attributeElement.addElement("name", name);
            attributeElement.addElement("value", value);
        }
        return requestElement.toXMLString();
    }

    protected PortletRequestModel() {
        this._authType = null;
        this._contentType = null;
        this._contextPath = null;
        this._lifecycle = null;
        this._locale = null;
        this._portletMode = null;
        this._portletNamespace = null;
        this._portletRequest = null;
        this._portletResponse = null;
        this._portletSessionId = null;
        this._remoteUser = null;
        this._scheme = null;
        this._secure = false;
        this._serverName = null;
        this._serverPort = 0;
        this._themeDisplayModel = null;
        this._windowState = null;
    }

    protected Map<String, Object> filterInvalidAttributes(Map<String, Object> map) {
        map = new HashMap<String, Object>(map);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        entrySet.removeIf(entry -> !PortletRequestModel._isValidAttributeName((String)entry.getKey()) || !PortletRequestModel._isValidAttributeValue(entry.getValue()));
        return map;
    }

    private static boolean _isValidAttributeName(String name) {
        return !StringUtil.equalsIgnoreCase(name, "PORTLET_RENDER_PARAMETERS_") && !StringUtil.equalsIgnoreCase(name, "j_password") && !StringUtil.equalsIgnoreCase(name, "LAYOUT_CONTENT") && !StringUtil.equalsIgnoreCase(name, "LAYOUTS") && !StringUtil.equalsIgnoreCase(name, "USER_PASSWORD") && !name.startsWith("javax.") && !name.startsWith("liferay-ui:");
    }

    private static boolean _isValidAttributeValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            return !col.isEmpty();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return !map.isEmpty();
        }
        String objString = String.valueOf(obj);
        if (Validator.isNull(objString)) {
            return false;
        }
        String hashCode = "@".concat(StringUtil.toHexString(obj.hashCode()));
        return !objString.endsWith(hashCode);
    }

    private void _initAttributes() {
        if (this._attributes != null) {
            return;
        }
        this._attributes = new HashMap<String, Object>();
        Enumeration enumeration = this._portletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = this._portletRequest.getAttribute(name);
            this._attributes.put(name, value);
        }
    }

    private void _initParameters() {
        if (this._parameters != null) {
            return;
        }
        this._parameters = new HashMap<String, String[]>(this._portletRequest.getParameterMap());
    }

    private void _initPortletSessionAttributes() {
        block3: {
            if (this._portletScopeSessioAttributes != null) {
                return;
            }
            PortletSession portletSession = this._portletRequest.getPortletSession();
            try {
                this._portletScopeSessioAttributes = portletSession.getAttributeMap(2);
                this._applicationScopeSessionAttributes = portletSession.getAttributeMap(1);
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(ise.getMessage());
            }
        }
    }

    private void _initURLs() {
        if (this._resourceURL == null && this._portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse;
            block16: {
                block15: {
                    mimeResponse = (MimeResponse)this._portletResponse;
                    try {
                        PortletURL actionURL = mimeResponse.createActionURL();
                        this._actionURL = actionURL.toString();
                    }
                    catch (IllegalStateException ise) {
                        if (!_log.isWarnEnabled()) break block15;
                        _log.warn(ise.getMessage());
                    }
                }
                try {
                    PortletURL renderURL = mimeResponse.createRenderURL();
                    this._renderURL = renderURL.toString();
                    try {
                        renderURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                        this._renderURLExclusive = renderURL.toString();
                    }
                    catch (WindowStateException windowStateException) {
                        // empty catch block
                    }
                    try {
                        renderURL.setWindowState(LiferayWindowState.MAXIMIZED);
                        this._renderURLMaximized = renderURL.toString();
                    }
                    catch (WindowStateException windowStateException) {
                        // empty catch block
                    }
                    try {
                        renderURL.setWindowState(LiferayWindowState.MINIMIZED);
                        this._renderURLMinimized = renderURL.toString();
                    }
                    catch (WindowStateException windowStateException) {
                        // empty catch block
                    }
                    try {
                        renderURL.setWindowState(LiferayWindowState.NORMAL);
                        this._renderURLNormal = renderURL.toString();
                    }
                    catch (WindowStateException windowStateException) {
                        // empty catch block
                    }
                    try {
                        renderURL.setWindowState(LiferayWindowState.POP_UP);
                        this._renderURLPopUp = renderURL.toString();
                    }
                    catch (WindowStateException windowStateException) {}
                }
                catch (IllegalStateException ise) {
                    if (!_log.isWarnEnabled()) break block16;
                    _log.warn(ise.getMessage());
                }
            }
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            String resourceURLString = HttpUtil.removeParameter(resourceURL.toString(), this._portletNamespace + "struts_action");
            resourceURLString = HttpUtil.removeParameter(resourceURLString, this._portletNamespace + "redirect");
            this._resourceURL = resourceURL.toString();
        }
    }
}

