/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.AddPortletProvider;
import com.liferay.portal.kernel.portlet.BrowsePortletProvider;
import com.liferay.portal.kernel.portlet.EditPortletProvider;
import com.liferay.portal.kernel.portlet.ManagePortletProvider;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PreviewPortletProvider;
import com.liferay.portal.kernel.portlet.ViewPortletProvider;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class PortletProviderUtil {
    private static final ServiceTrackerMap<String, AddPortletProvider> _addServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(AddPortletProvider.class, "model.class.name");
    private static final ServiceTrackerMap<String, BrowsePortletProvider> _browseServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(BrowsePortletProvider.class, "model.class.name");
    private static final ServiceTrackerMap<String, EditPortletProvider> _editServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(EditPortletProvider.class, "model.class.name");
    private static final ServiceTrackerMap<String, ManagePortletProvider> _manageServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(ManagePortletProvider.class, "model.class.name");
    private static final ServiceTrackerMap<String, PreviewPortletProvider> _previewServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(PreviewPortletProvider.class, "model.class.name");
    private static final ServiceTrackerMap<String, ViewPortletProvider> _viewServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(ViewPortletProvider.class, "model.class.name");

    public static String getPortletId(String className, PortletProvider.Action action) {
        PortletProvider portletProvider = PortletProviderUtil.getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletName();
        }
        return "";
    }

    public static PortletURL getPortletURL(HttpServletRequest httpServletRequest, Group group, String className, PortletProvider.Action action) throws PortalException {
        PortletProvider portletProvider = PortletProviderUtil.getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletURL(httpServletRequest, group);
        }
        return null;
    }

    public static PortletURL getPortletURL(HttpServletRequest httpServletRequest, String className, PortletProvider.Action action) throws PortalException {
        PortletProvider portletProvider = PortletProviderUtil.getPortletProvider(className, action);
        if (portletProvider != null) {
            return portletProvider.getPortletURL(httpServletRequest);
        }
        return null;
    }

    public static PortletURL getPortletURL(PortletRequest portletRequest, Group group, String className, PortletProvider.Action action) throws PortalException {
        return PortletProviderUtil.getPortletURL(PortalUtil.getHttpServletRequest(portletRequest), group, className, action);
    }

    public static PortletURL getPortletURL(PortletRequest portletRequest, String className, PortletProvider.Action action) throws PortalException {
        return PortletProviderUtil.getPortletURL(PortalUtil.getHttpServletRequest(portletRequest), className, action);
    }

    protected static PortletProvider getPortletProvider(String className, PortletProvider.Action action) {
        if (action.equals((Object)PortletProvider.Action.ADD)) {
            return PortletProviderUtil.getPortletProvider(className, _addServiceTrackerMap);
        }
        if (action.equals((Object)PortletProvider.Action.BROWSE)) {
            return PortletProviderUtil.getPortletProvider(className, _browseServiceTrackerMap);
        }
        if (action.equals((Object)PortletProvider.Action.EDIT)) {
            return PortletProviderUtil.getPortletProvider(className, _editServiceTrackerMap);
        }
        if (action.equals((Object)PortletProvider.Action.MANAGE)) {
            return PortletProviderUtil.getPortletProvider(className, _manageServiceTrackerMap);
        }
        if (action.equals((Object)PortletProvider.Action.PREVIEW)) {
            return PortletProviderUtil.getPortletProvider(className, _previewServiceTrackerMap);
        }
        if (action.equals((Object)PortletProvider.Action.VIEW)) {
            return PortletProviderUtil.getPortletProvider(className, _viewServiceTrackerMap);
        }
        return null;
    }

    protected static PortletProvider getPortletProvider(String className, ServiceTrackerMap<String, ? extends PortletProvider> serviceTrackerMap) {
        PortletProvider portletProvider = serviceTrackerMap.getService(className);
        if (portletProvider == null && PortletProviderUtil.isAssetObject(className)) {
            portletProvider = serviceTrackerMap.getService(AssetEntry.class.getName());
        }
        return portletProvider;
    }

    protected static boolean isAssetObject(String className) {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        return assetRendererFactory != null;
    }
}

