/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.monitoring;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;

public class DataSampleThreadLocal {
    private static final ThreadLocal<DataSampleThreadLocal> _dataSampleThreadLocal = new CentralizedThreadLocal<DataSampleThreadLocal>(DataSampleThreadLocal.class + "._dataSampleThreadLocal", DataSampleThreadLocal::new, Function.identity(), true);
    private final Queue<DataSample> _dataSamples = new ConcurrentLinkedQueue<DataSample>();
    private final long _monitorTime = System.currentTimeMillis();

    public static void addDataSample(DataSample dataSample) {
        DataSampleThreadLocal dataSampleThreadLocal = _dataSampleThreadLocal.get();
        dataSampleThreadLocal._addDataSample(dataSample);
    }

    public static void clearDataSamples() {
        _dataSampleThreadLocal.remove();
    }

    public static List<DataSample> getDataSamples() {
        DataSampleThreadLocal dataSampleThreadLocal = _dataSampleThreadLocal.get();
        return ListUtil.fromCollection(dataSampleThreadLocal._getDataSamples());
    }

    public static void initialize() {
        _dataSampleThreadLocal.get();
    }

    public long getMonitorTime() {
        return this._monitorTime;
    }

    private DataSampleThreadLocal() {
    }

    private void _addDataSample(DataSample dataSample) {
        this._dataSamples.add(dataSample);
    }

    private Queue<DataSample> _getDataSamples() {
        return this._dataSamples;
    }
}

