/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.framework;

import com.liferay.petra.reflect.ReflectionUtil;
import java.util.concurrent.atomic.AtomicReference;

public class ThrowableCollector {
    private final AtomicReference<Throwable> _atomicReference = new AtomicReference();

    public void collect(Throwable t) {
        do {
            Throwable throwable;
            if ((throwable = this._atomicReference.get()) == null) continue;
            throwable.addSuppressed(t);
            break;
        } while (!this._atomicReference.compareAndSet(null, t));
    }

    public Throwable getThrowable() {
        return this._atomicReference.get();
    }

    public void rethrow() {
        Throwable throwable = this._atomicReference.get();
        if (throwable != null) {
            ReflectionUtil.throwException(throwable);
        }
    }
}

