/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StackTraceUtil;
import java.io.Serializable;

public class MessageStatus
implements Serializable {
    private long _endTime;
    private String _exceptionMessage;
    private String _exceptionStackTrace;
    private Object _payload;
    private long _startTime;

    public long getDuration() {
        return this._endTime - this._startTime;
    }

    public String getExceptionMessage() {
        return this._exceptionMessage;
    }

    public String getExceptionStackTrace() {
        return this._exceptionStackTrace;
    }

    public Object getPayload() {
        return this._payload;
    }

    public boolean hasException() {
        return this._exceptionStackTrace != null;
    }

    public void setException(Exception e) {
        this._exceptionMessage = e.getMessage();
        this._exceptionStackTrace = StackTraceUtil.getStackTrace(e);
    }

    public void setPayload(Object payload) {
        this._payload = payload;
    }

    public void startTimer() {
        this._startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        this._endTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{startTime=");
        sb.append(this._startTime);
        sb.append(", endTime=");
        sb.append(this._endTime);
        sb.append(", payload=");
        sb.append(this._payload);
        sb.append(", errorMessage=");
        sb.append(this._exceptionMessage);
        sb.append(", errorStackTrace=");
        sb.append(this._exceptionStackTrace);
        sb.append("}");
        return sb.toString();
    }
}

