/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import java.io.Serializable;
import java.util.Objects;

public class DestinationConfiguration
implements Serializable {
    public static final String DESTINATION_TYPE_PARALLEL = "parallel";
    public static final String DESTINATION_TYPE_SERIAL = "serial";
    public static final String DESTINATION_TYPE_SYNCHRONOUS = "synchronous";
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private final String _destinationName;
    private String _destinationType;
    private int _maximumQueueSize = Integer.MAX_VALUE;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    public static DestinationConfiguration createParallelDestinationConfiguration(String destinationName) {
        return new DestinationConfiguration(DESTINATION_TYPE_PARALLEL, destinationName);
    }

    public static DestinationConfiguration createSerialDestinationConfiguration(String destinationName) {
        return new DestinationConfiguration(DESTINATION_TYPE_SERIAL, destinationName);
    }

    public static DestinationConfiguration createSynchronousDestinationConfiguration(String destinationName) {
        return new DestinationConfiguration(DESTINATION_TYPE_SYNCHRONOUS, destinationName);
    }

    public DestinationConfiguration(String destinationType, String destinationName) {
        this._destinationType = destinationType;
        this._destinationName = destinationName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration destinationConfiguration = (DestinationConfiguration)object;
        return Objects.equals(this._destinationName, destinationConfiguration._destinationName);
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public String getDestinationType() {
        return this._destinationType;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    @Deprecated
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this._rejectedExecutionHandler;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    public int hashCode() {
        return this._destinationName.hashCode();
    }

    public void setDestinationType(String destinationType) {
        this._destinationType = destinationType;
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    @Deprecated
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
    }

    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
    }

    public String toString() {
        StringBundler sb = new StringBundler(13);
        sb.append("{_destinationName=");
        sb.append(this._destinationName);
        sb.append(", _destinationType=");
        sb.append(this._destinationType);
        sb.append(", _maximumQueueSize=");
        sb.append(this._maximumQueueSize);
        sb.append(", _rejectedExecutionHandler=");
        sb.append(this._rejectedExecutionHandler);
        sb.append(", _workersCoreSize=");
        sb.append(this._workersCoreSize);
        sb.append(", _workersMaxSize=");
        sb.append(this._workersMaxSize);
        sb.append("}");
        return sb.toString();
    }
}

