/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent.test;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.test.MarkerBlockingJob;
import java.util.concurrent.TimeUnit;

public class TestUtil {
    public static final long KEEPALIVE_TIME = 50L;
    public static final long KEEPALIVE_WAIT = 100L;
    public static final long LONG_WAIT = 30000L;
    public static final long SHORT_WAIT = 10L;

    public static void closePool(ThreadPoolExecutor threadPoolExecutor) {
        TestUtil.closePool(threadPoolExecutor, false);
    }

    public static void closePool(ThreadPoolExecutor threadPoolExecutor, boolean force) {
        try {
            if (force) {
                threadPoolExecutor.shutdownNow();
            } else {
                threadPoolExecutor.shutdown();
            }
            if (!threadPoolExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException();
            }
            if (!threadPoolExecutor.isTerminated()) {
                throw new IllegalStateException();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException();
        }
    }

    public static void unblock(MarkerBlockingJob ... markerBlockingJobs) {
        for (MarkerBlockingJob markerBlockingJob : markerBlockingJobs) {
            markerBlockingJob.unBlock();
        }
    }

    public static void waitUntilBlock(MarkerBlockingJob ... markerBlockingJobs) throws InterruptedException {
        for (MarkerBlockingJob markerBlockingJob : markerBlockingJobs) {
            markerBlockingJob.waitUntilBlock();
        }
    }

    public static void waitUntilEnded(MarkerBlockingJob ... markerBlockingJobs) throws InterruptedException {
        for (MarkerBlockingJob markerBlockingJob : markerBlockingJobs) {
            markerBlockingJob.waitUntilEnded();
        }
        Thread.sleep(10L);
    }
}

