/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class MappedMethodCallableInvocationHandler
implements InvocationHandler {
    private final Map<Method, Callable<?>> _afterCallables = new HashMap();
    private final Map<Method, Callable<?>> _beforeCallables = new HashMap();
    private final Object _instance;
    private final boolean _removeOnCall;

    public MappedMethodCallableInvocationHandler(Object instance, boolean removeOnCall) {
        this._instance = instance;
        this._removeOnCall = removeOnCall;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Callable<?> beforeCallable = null;
        beforeCallable = this._removeOnCall ? this._beforeCallables.remove(method) : this._beforeCallables.get(method);
        if (beforeCallable != null) {
            beforeCallable.call();
        }
        try {
            Object object = method.invoke(this._instance, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            Callable<?> afterCallable = null;
            afterCallable = this._removeOnCall ? this._afterCallables.remove(method) : this._afterCallables.get(method);
            if (afterCallable != null) {
                afterCallable.call();
            }
        }
    }

    public void putAfterCallable(Method method, Callable<?> callable) {
        this._afterCallables.put(method, callable);
    }

    public void putBeforeCallable(Method method, Callable<?> callable) {
        this._beforeCallables.put(method, callable);
    }
}

