/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public class AsyncBroker<K, V> {
    private final ConcurrentMap<K, DefaultNoticeableFuture<V>> _defaultNoticeableFutures = new ConcurrentReferenceValueHashMap<K, DefaultNoticeableFuture<V>>(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public Map<K, NoticeableFuture<V>> getOpenBids() {
        return Collections.unmodifiableMap(this._defaultNoticeableFutures);
    }

    public NoticeableFuture<V> post(K key) {
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture<V>(){

            protected void finalize() {
                this.cancel(true);
            }
        };
        NoticeableFuture<V> previousNoticeableFuture = this._post(key, defaultNoticeableFuture);
        if (previousNoticeableFuture == null) {
            return defaultNoticeableFuture;
        }
        return previousNoticeableFuture;
    }

    public NoticeableFuture<V> post(K key, boolean[] newMarker) {
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        NoticeableFuture previousNoticeableFuture = this._post(key, defaultNoticeableFuture);
        if (previousNoticeableFuture == null) {
            newMarker[0] = true;
            return defaultNoticeableFuture;
        }
        newMarker[0] = false;
        return previousNoticeableFuture;
    }

    @Deprecated
    public NoticeableFuture<V> post(K key, DefaultNoticeableFuture<V> defaultNoticeableFuture) {
        return this._post(key, defaultNoticeableFuture);
    }

    public NoticeableFuture<V> take(K key) {
        return (NoticeableFuture)this._defaultNoticeableFutures.remove(key);
    }

    public boolean takeWithException(K key, Throwable throwable) {
        DefaultNoticeableFuture defaultNoticeableFuture = (DefaultNoticeableFuture)this._defaultNoticeableFutures.remove(key);
        if (defaultNoticeableFuture == null) {
            return false;
        }
        defaultNoticeableFuture.setException(throwable);
        return true;
    }

    public boolean takeWithResult(K key, V result) {
        DefaultNoticeableFuture defaultNoticeableFuture = (DefaultNoticeableFuture)this._defaultNoticeableFutures.remove(key);
        if (defaultNoticeableFuture == null) {
            return false;
        }
        defaultNoticeableFuture.set(result);
        return true;
    }

    private NoticeableFuture<V> _post(final K key, final DefaultNoticeableFuture<V> defaultNoticeableFuture) {
        DefaultNoticeableFuture<V> previousDefaultNoticeableFuture = this._defaultNoticeableFutures.putIfAbsent(key, defaultNoticeableFuture);
        if (previousDefaultNoticeableFuture != null) {
            return previousDefaultNoticeableFuture;
        }
        defaultNoticeableFuture.addFutureListener(new FutureListener<V>(){

            @Override
            public void complete(Future<V> future) {
                AsyncBroker.this._defaultNoticeableFutures.remove(key, defaultNoticeableFuture);
            }
        });
        return null;
    }
}

