/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterNode;
import java.io.Serializable;

public class ClusterNodeResponse
implements Serializable {
    private final ClusterNode _clusterNode;
    private final Exception _exception;
    private final Serializable _result;
    private final String _uuid;

    public static ClusterNodeResponse createExceptionClusterNodeResponse(ClusterNode clusterNode, String uuid, Exception exception) {
        return new ClusterNodeResponse(clusterNode, uuid, null, exception);
    }

    public static ClusterNodeResponse createResultClusterNodeResponse(ClusterNode clusterNode, String uuid, Serializable result) {
        return new ClusterNodeResponse(clusterNode, uuid, result, null);
    }

    public ClusterNode getClusterNode() {
        return this._clusterNode;
    }

    public Exception getException() {
        return this._exception;
    }

    public Serializable getResult() {
        if (this._exception != null) {
            return (Serializable)ReflectionUtil.throwException(this._exception);
        }
        return this._result;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean hasException() {
        return this._exception != null;
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{clusterNode=");
        sb.append(this._clusterNode);
        if (this.hasException()) {
            sb.append(", exception=");
            sb.append(this._exception);
        } else {
            sb.append(", result=");
            sb.append(this._result);
        }
        sb.append(", uuid=");
        sb.append(this._uuid);
        sb.append("}");
        return sb.toString();
    }

    private ClusterNodeResponse(ClusterNode clusterNode, String uuid, Serializable result, Exception exception) {
        if (clusterNode == null) {
            throw new NullPointerException("Cluster node is null");
        }
        this._clusterNode = clusterNode;
        this._uuid = uuid;
        this._result = result;
        this._exception = exception;
    }
}

